// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details of an instance group in a SageMaker HyperPod cluster.
 */
public class ClusterInstanceGroupDetails private constructor(builder: Builder) {
    /**
     * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
     */
    public val currentCount: kotlin.Int? = builder.currentCount
    /**
     * The execution role for the instance group to assume.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The name of the instance group of a SageMaker HyperPod cluster.
     */
    public val instanceGroupName: kotlin.String? = builder.instanceGroupName
    /**
     * The additional storage configurations for the instances in the SageMaker HyperPod cluster instance group.
     */
    public val instanceStorageConfigs: List<ClusterInstanceStorageConfig>? = builder.instanceStorageConfigs
    /**
     * The instance type of the instance group of a SageMaker HyperPod cluster.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = builder.instanceType
    /**
     * Details of LifeCycle configuration for the instance group.
     */
    public val lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = builder.lifeCycleConfig
    /**
     * A flag indicating whether deep health checks should be performed when the cluster instance group is created or updated.
     */
    public val onStartDeepHealthChecks: List<DeepHealthCheckType>? = builder.onStartDeepHealthChecks
    /**
     * The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
     */
    public val targetCount: kotlin.Int? = builder.targetCount
    /**
     * The number you specified to `TreadsPerCore` in `CreateCluster` for enabling or disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading. For more information, see the reference table of [CPU cores and threads per CPU core per instance type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val threadsPerCore: kotlin.Int? = builder.threadsPerCore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterInstanceGroupDetails(")
        append("currentCount=$currentCount,")
        append("executionRole=$executionRole,")
        append("instanceGroupName=$instanceGroupName,")
        append("instanceStorageConfigs=$instanceStorageConfigs,")
        append("instanceType=$instanceType,")
        append("lifeCycleConfig=$lifeCycleConfig,")
        append("onStartDeepHealthChecks=$onStartDeepHealthChecks,")
        append("targetCount=$targetCount,")
        append("threadsPerCore=$threadsPerCore")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentCount ?: 0
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (instanceGroupName?.hashCode() ?: 0)
        result = 31 * result + (instanceStorageConfigs?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleConfig?.hashCode() ?: 0)
        result = 31 * result + (onStartDeepHealthChecks?.hashCode() ?: 0)
        result = 31 * result + (targetCount ?: 0)
        result = 31 * result + (threadsPerCore ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterInstanceGroupDetails

        if (currentCount != other.currentCount) return false
        if (executionRole != other.executionRole) return false
        if (instanceGroupName != other.instanceGroupName) return false
        if (instanceStorageConfigs != other.instanceStorageConfigs) return false
        if (instanceType != other.instanceType) return false
        if (lifeCycleConfig != other.lifeCycleConfig) return false
        if (onStartDeepHealthChecks != other.onStartDeepHealthChecks) return false
        if (targetCount != other.targetCount) return false
        if (threadsPerCore != other.threadsPerCore) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
         */
        public var currentCount: kotlin.Int? = null
        /**
         * The execution role for the instance group to assume.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The name of the instance group of a SageMaker HyperPod cluster.
         */
        public var instanceGroupName: kotlin.String? = null
        /**
         * The additional storage configurations for the instances in the SageMaker HyperPod cluster instance group.
         */
        public var instanceStorageConfigs: List<ClusterInstanceStorageConfig>? = null
        /**
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = null
        /**
         * Details of LifeCycle configuration for the instance group.
         */
        public var lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = null
        /**
         * A flag indicating whether deep health checks should be performed when the cluster instance group is created or updated.
         */
        public var onStartDeepHealthChecks: List<DeepHealthCheckType>? = null
        /**
         * The number of instances you specified to add to the instance group of a SageMaker HyperPod cluster.
         */
        public var targetCount: kotlin.Int? = null
        /**
         * The number you specified to `TreadsPerCore` in `CreateCluster` for enabling or disabling multithreading. For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading. For more information, see the reference table of [CPU cores and threads per CPU core per instance type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var threadsPerCore: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupDetails) : this() {
            this.currentCount = x.currentCount
            this.executionRole = x.executionRole
            this.instanceGroupName = x.instanceGroupName
            this.instanceStorageConfigs = x.instanceStorageConfigs
            this.instanceType = x.instanceType
            this.lifeCycleConfig = x.lifeCycleConfig
            this.onStartDeepHealthChecks = x.onStartDeepHealthChecks
            this.targetCount = x.targetCount
            this.threadsPerCore = x.threadsPerCore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceGroupDetails = ClusterInstanceGroupDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig] inside the given [block]
         */
        public fun lifeCycleConfig(block: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.Builder.() -> kotlin.Unit) {
            this.lifeCycleConfig = aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
