// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The container for the metadata for the ClarifyCheck step. For more information, see the topic on [ClarifyCheck step](https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-clarify-check) in the *Amazon SageMaker Developer Guide*.
 */
public class ClarifyCheckStepMetadata private constructor(builder: Builder) {
    /**
     * The Amazon S3 URI of baseline constraints file to be used for the drift check.
     */
    public val baselineUsedForDriftCheckConstraints: kotlin.String? = builder.baselineUsedForDriftCheckConstraints
    /**
     * The Amazon S3 URI of the newly calculated baseline constraints file.
     */
    public val calculatedBaselineConstraints: kotlin.String? = builder.calculatedBaselineConstraints
    /**
     * The Amazon Resource Name (ARN) of the check processing job that was run by this step's execution.
     */
    public val checkJobArn: kotlin.String? = builder.checkJobArn
    /**
     * The type of the Clarify Check step
     */
    public val checkType: kotlin.String? = builder.checkType
    /**
     * The model package group name.
     */
    public val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * This flag indicates if a newly calculated baseline can be accessed through step properties `BaselineUsedForDriftCheckConstraints` and `BaselineUsedForDriftCheckStatistics`. If it is set to `False`, the previous baseline of the configured check type must also be available. These can be accessed through the `BaselineUsedForDriftCheckConstraints` property.
     */
    public val registerNewBaseline: kotlin.Boolean? = builder.registerNewBaseline
    /**
     * This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to `False`, the previous baseline of the configured check type must be available.
     */
    public val skipCheck: kotlin.Boolean? = builder.skipCheck
    /**
     * The Amazon S3 URI of the violation report if violations are detected.
     */
    public val violationReport: kotlin.String? = builder.violationReport

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClarifyCheckStepMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClarifyCheckStepMetadata(")
        append("baselineUsedForDriftCheckConstraints=$baselineUsedForDriftCheckConstraints,")
        append("calculatedBaselineConstraints=$calculatedBaselineConstraints,")
        append("checkJobArn=$checkJobArn,")
        append("checkType=$checkType,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("registerNewBaseline=$registerNewBaseline,")
        append("skipCheck=$skipCheck,")
        append("violationReport=$violationReport")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineUsedForDriftCheckConstraints?.hashCode() ?: 0
        result = 31 * result + (calculatedBaselineConstraints?.hashCode() ?: 0)
        result = 31 * result + (checkJobArn?.hashCode() ?: 0)
        result = 31 * result + (checkType?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (registerNewBaseline?.hashCode() ?: 0)
        result = 31 * result + (skipCheck?.hashCode() ?: 0)
        result = 31 * result + (violationReport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClarifyCheckStepMetadata

        if (baselineUsedForDriftCheckConstraints != other.baselineUsedForDriftCheckConstraints) return false
        if (calculatedBaselineConstraints != other.calculatedBaselineConstraints) return false
        if (checkJobArn != other.checkJobArn) return false
        if (checkType != other.checkType) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (registerNewBaseline != other.registerNewBaseline) return false
        if (skipCheck != other.skipCheck) return false
        if (violationReport != other.violationReport) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClarifyCheckStepMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 URI of baseline constraints file to be used for the drift check.
         */
        public var baselineUsedForDriftCheckConstraints: kotlin.String? = null
        /**
         * The Amazon S3 URI of the newly calculated baseline constraints file.
         */
        public var calculatedBaselineConstraints: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the check processing job that was run by this step's execution.
         */
        public var checkJobArn: kotlin.String? = null
        /**
         * The type of the Clarify Check step
         */
        public var checkType: kotlin.String? = null
        /**
         * The model package group name.
         */
        public var modelPackageGroupName: kotlin.String? = null
        /**
         * This flag indicates if a newly calculated baseline can be accessed through step properties `BaselineUsedForDriftCheckConstraints` and `BaselineUsedForDriftCheckStatistics`. If it is set to `False`, the previous baseline of the configured check type must also be available. These can be accessed through the `BaselineUsedForDriftCheckConstraints` property.
         */
        public var registerNewBaseline: kotlin.Boolean? = null
        /**
         * This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to `False`, the previous baseline of the configured check type must be available.
         */
        public var skipCheck: kotlin.Boolean? = null
        /**
         * The Amazon S3 URI of the violation report if violations are detected.
         */
        public var violationReport: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClarifyCheckStepMetadata) : this() {
            this.baselineUsedForDriftCheckConstraints = x.baselineUsedForDriftCheckConstraints
            this.calculatedBaselineConstraints = x.calculatedBaselineConstraints
            this.checkJobArn = x.checkJobArn
            this.checkType = x.checkType
            this.modelPackageGroupName = x.modelPackageGroupName
            this.registerNewBaseline = x.registerNewBaseline
            this.skipCheck = x.skipCheck
            this.violationReport = x.violationReport
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClarifyCheckStepMetadata = ClarifyCheckStepMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
