// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Amazon S3 data source.
 */
public class AutoMls3DataSource private constructor(builder: Builder) {
    /**
     * The data type.
     * + If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix for model training.The `S3Prefix` should have the following format:`s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER-OR-FILE`
     * + If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.A `ManifestFile` should have the format shown below:`[ {"prefix": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/DOC-EXAMPLE-PREFIX/"}, ``"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-1",``"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-2",``... "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-N" ]`
     * + If you choose `AugmentedManifestFile`, `S3Uri` identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. `AugmentedManifestFile` is available for V2 API jobs only (for example, for jobs created by calling `CreateAutoMLJobV2`).Here is a minimal, single-record example of an `AugmentedManifestFile`:`{"source-ref": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/cats/cat.jpg",``"label-metadata": {"class-name": "cat"` }For more information on `AugmentedManifestFile`, see [Provide Dataset Metadata to Training Jobs with an Augmented Manifest File](https://docs.aws.amazon.com/sagemaker/latest/dg/augmented-manifest.html).
     */
    public val s3DataType: aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataType? = builder.s3DataType
    /**
     * The URL to the Amazon S3 data source. The Uri refers to the Amazon S3 prefix or ManifestFile depending on the data type.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMls3DataSource(")
        append("s3DataType=$s3DataType,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3DataType?.hashCode() ?: 0
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMls3DataSource

        if (s3DataType != other.s3DataType) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data type.
         * + If you choose `S3Prefix`, `S3Uri` identifies a key name prefix. SageMaker uses all objects that match the specified key name prefix for model training.The `S3Prefix` should have the following format:`s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER-OR-FILE`
         * + If you choose `ManifestFile`, `S3Uri` identifies an object that is a manifest file containing a list of object keys that you want SageMaker to use for model training.A `ManifestFile` should have the format shown below:`[ {"prefix": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/DOC-EXAMPLE-PREFIX/"}, ``"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-1",``"DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-2",``... "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-N" ]`
         * + If you choose `AugmentedManifestFile`, `S3Uri` identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. `AugmentedManifestFile` is available for V2 API jobs only (for example, for jobs created by calling `CreateAutoMLJobV2`).Here is a minimal, single-record example of an `AugmentedManifestFile`:`{"source-ref": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/cats/cat.jpg",``"label-metadata": {"class-name": "cat"` }For more information on `AugmentedManifestFile`, see [Provide Dataset Metadata to Training Jobs with an Augmented Manifest File](https://docs.aws.amazon.com/sagemaker/latest/dg/augmented-manifest.html).
         */
        public var s3DataType: aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataType? = null
        /**
         * The URL to the Amazon S3 data source. The Uri refers to the Amazon S3 prefix or ManifestFile depending on the data type.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataSource) : this() {
            this.s3DataType = x.s3DataType
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMls3DataSource = AutoMls3DataSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
