// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.UpdateNotebookInstanceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateNotebookInstanceOperationDeserializer: HttpDeserializer.NonStreaming<UpdateNotebookInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateNotebookInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateNotebookInstanceError(context, call, payload)
        }
        val builder = UpdateNotebookInstanceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateNotebookInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
