// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceComponentResponse
import aws.sdk.kotlin.services.sagemaker.model.InferenceComponentRuntimeConfigSummary
import aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecificationSummary
import aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStatus
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeInferenceComponentOperationDeserializer: HttpDeserializer.NonStreaming<DescribeInferenceComponentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeInferenceComponentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeInferenceComponentError(context, call, payload)
        }
        val builder = DescribeInferenceComponentResponse.Builder()

        if (payload != null) {
            deserializeDescribeInferenceComponentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeInferenceComponentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInferenceComponentOperationBody(builder: DescribeInferenceComponentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ENDPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointArn"))
    val ENDPOINTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointName"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val INFERENCECOMPONENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceComponentArn"))
    val INFERENCECOMPONENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InferenceComponentName"))
    val INFERENCECOMPONENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InferenceComponentStatus"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val RUNTIMECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuntimeConfig"))
    val SPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Specification"))
    val VARIANTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VariantName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ENDPOINTARN_DESCRIPTOR)
        field(ENDPOINTNAME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(INFERENCECOMPONENTARN_DESCRIPTOR)
        field(INFERENCECOMPONENTNAME_DESCRIPTOR)
        field(INFERENCECOMPONENTSTATUS_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(RUNTIMECONFIG_DESCRIPTOR)
        field(SPECIFICATION_DESCRIPTOR)
        field(VARIANTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENDPOINTARN_DESCRIPTOR.index -> builder.endpointArn = deserializeString()
                ENDPOINTNAME_DESCRIPTOR.index -> builder.endpointName = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                INFERENCECOMPONENTARN_DESCRIPTOR.index -> builder.inferenceComponentArn = deserializeString()
                INFERENCECOMPONENTNAME_DESCRIPTOR.index -> builder.inferenceComponentName = deserializeString()
                INFERENCECOMPONENTSTATUS_DESCRIPTOR.index -> builder.inferenceComponentStatus = deserializeString().let { InferenceComponentStatus.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                RUNTIMECONFIG_DESCRIPTOR.index -> builder.runtimeConfig = deserializeInferenceComponentRuntimeConfigSummaryDocument(deserializer)
                SPECIFICATION_DESCRIPTOR.index -> builder.specification = deserializeInferenceComponentSpecificationSummaryDocument(deserializer)
                VARIANTNAME_DESCRIPTOR.index -> builder.variantName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
