// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeImageVersionResponse
import aws.sdk.kotlin.services.sagemaker.model.ImageVersionStatus
import aws.sdk.kotlin.services.sagemaker.model.JobType
import aws.sdk.kotlin.services.sagemaker.model.Processor
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.sdk.kotlin.services.sagemaker.model.VendorGuidance
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeImageVersionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeImageVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeImageVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeImageVersionError(context, call, payload)
        }
        val builder = DescribeImageVersionResponse.Builder()

        if (payload != null) {
            deserializeDescribeImageVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeImageVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeImageVersionOperationBody(builder: DescribeImageVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaseImage"))
    val CONTAINERIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContainerImage"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HOROVOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Horovod"))
    val IMAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageArn"))
    val IMAGEVERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ImageVersionArn"))
    val IMAGEVERSIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ImageVersionStatus"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobType"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MLFRAMEWORK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MLFramework"))
    val PROCESSOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Processor"))
    val PROGRAMMINGLANG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProgrammingLang"))
    val RELEASENOTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReleaseNotes"))
    val VENDORGUIDANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VendorGuidance"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEIMAGE_DESCRIPTOR)
        field(CONTAINERIMAGE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HOROVOD_DESCRIPTOR)
        field(IMAGEARN_DESCRIPTOR)
        field(IMAGEVERSIONARN_DESCRIPTOR)
        field(IMAGEVERSIONSTATUS_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MLFRAMEWORK_DESCRIPTOR)
        field(PROCESSOR_DESCRIPTOR)
        field(PROGRAMMINGLANG_DESCRIPTOR)
        field(RELEASENOTES_DESCRIPTOR)
        field(VENDORGUIDANCE_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEIMAGE_DESCRIPTOR.index -> builder.baseImage = deserializeString()
                CONTAINERIMAGE_DESCRIPTOR.index -> builder.containerImage = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HOROVOD_DESCRIPTOR.index -> builder.horovod = deserializeBoolean()
                IMAGEARN_DESCRIPTOR.index -> builder.imageArn = deserializeString()
                IMAGEVERSIONARN_DESCRIPTOR.index -> builder.imageVersionArn = deserializeString()
                IMAGEVERSIONSTATUS_DESCRIPTOR.index -> builder.imageVersionStatus = deserializeString().let { ImageVersionStatus.fromValue(it) }
                JOBTYPE_DESCRIPTOR.index -> builder.jobType = deserializeString().let { JobType.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MLFRAMEWORK_DESCRIPTOR.index -> builder.mlFramework = deserializeString()
                PROCESSOR_DESCRIPTOR.index -> builder.processor = deserializeString().let { Processor.fromValue(it) }
                PROGRAMMINGLANG_DESCRIPTOR.index -> builder.programmingLang = deserializeString()
                RELEASENOTES_DESCRIPTOR.index -> builder.releaseNotes = deserializeString()
                VENDORGUIDANCE_DESCRIPTOR.index -> builder.vendorGuidance = deserializeString().let { VendorGuidance.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
