// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeHubContentResponse
import aws.sdk.kotlin.services.sagemaker.model.HubContentDependency
import aws.sdk.kotlin.services.sagemaker.model.HubContentStatus
import aws.sdk.kotlin.services.sagemaker.model.HubContentSupportStatus
import aws.sdk.kotlin.services.sagemaker.model.HubContentType
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeHubContentOperationDeserializer: HttpDeserializer.NonStreaming<DescribeHubContentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeHubContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeHubContentError(context, call, payload)
        }
        val builder = DescribeHubContentResponse.Builder()

        if (payload != null) {
            deserializeDescribeHubContentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeHubContentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHubContentOperationBody(builder: DescribeHubContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DOCUMENTSCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentSchemaVersion"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val HUBCONTENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentArn"))
    val HUBCONTENTDEPENDENCIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HubContentDependencies"))
    val HUBCONTENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDescription"))
    val HUBCONTENTDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDisplayName"))
    val HUBCONTENTDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDocument"))
    val HUBCONTENTMARKDOWN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentMarkdown"))
    val HUBCONTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentName"))
    val HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HubContentSearchKeywords"))
    val HUBCONTENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HubContentStatus"))
    val HUBCONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HubContentType"))
    val HUBCONTENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentVersion"))
    val HUBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubName"))
    val REFERENCEMINVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReferenceMinVersion"))
    val SAGEMAKERPUBLICHUBCONTENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SageMakerPublicHubContentArn"))
    val SUPPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SupportStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DOCUMENTSCHEMAVERSION_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(HUBARN_DESCRIPTOR)
        field(HUBCONTENTARN_DESCRIPTOR)
        field(HUBCONTENTDEPENDENCIES_DESCRIPTOR)
        field(HUBCONTENTDESCRIPTION_DESCRIPTOR)
        field(HUBCONTENTDISPLAYNAME_DESCRIPTOR)
        field(HUBCONTENTDOCUMENT_DESCRIPTOR)
        field(HUBCONTENTMARKDOWN_DESCRIPTOR)
        field(HUBCONTENTNAME_DESCRIPTOR)
        field(HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR)
        field(HUBCONTENTSTATUS_DESCRIPTOR)
        field(HUBCONTENTTYPE_DESCRIPTOR)
        field(HUBCONTENTVERSION_DESCRIPTOR)
        field(HUBNAME_DESCRIPTOR)
        field(REFERENCEMINVERSION_DESCRIPTOR)
        field(SAGEMAKERPUBLICHUBCONTENTARN_DESCRIPTOR)
        field(SUPPORTSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DOCUMENTSCHEMAVERSION_DESCRIPTOR.index -> builder.documentSchemaVersion = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                HUBCONTENTARN_DESCRIPTOR.index -> builder.hubContentArn = deserializeString()
                HUBCONTENTDEPENDENCIES_DESCRIPTOR.index -> builder.hubContentDependencies =
                    deserializer.deserializeList(HUBCONTENTDEPENDENCIES_DESCRIPTOR) {
                        val col0 = mutableListOf<HubContentDependency>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHubContentDependencyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HUBCONTENTDESCRIPTION_DESCRIPTOR.index -> builder.hubContentDescription = deserializeString()
                HUBCONTENTDISPLAYNAME_DESCRIPTOR.index -> builder.hubContentDisplayName = deserializeString()
                HUBCONTENTDOCUMENT_DESCRIPTOR.index -> builder.hubContentDocument = deserializeString()
                HUBCONTENTMARKDOWN_DESCRIPTOR.index -> builder.hubContentMarkdown = deserializeString()
                HUBCONTENTNAME_DESCRIPTOR.index -> builder.hubContentName = deserializeString()
                HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR.index -> builder.hubContentSearchKeywords =
                    deserializer.deserializeList(HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HUBCONTENTSTATUS_DESCRIPTOR.index -> builder.hubContentStatus = deserializeString().let { HubContentStatus.fromValue(it) }
                HUBCONTENTTYPE_DESCRIPTOR.index -> builder.hubContentType = deserializeString().let { HubContentType.fromValue(it) }
                HUBCONTENTVERSION_DESCRIPTOR.index -> builder.hubContentVersion = deserializeString()
                HUBNAME_DESCRIPTOR.index -> builder.hubName = deserializeString()
                REFERENCEMINVERSION_DESCRIPTOR.index -> builder.referenceMinVersion = deserializeString()
                SAGEMAKERPUBLICHUBCONTENTARN_DESCRIPTOR.index -> builder.sageMakerPublicHubContentArn = deserializeString()
                SUPPORTSTATUS_DESCRIPTOR.index -> builder.supportStatus = deserializeString().let { HubContentSupportStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
