// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.CreateSpaceRequest
import aws.sdk.kotlin.services.sagemaker.model.OwnershipSettings
import aws.sdk.kotlin.services.sagemaker.model.SpaceSettings
import aws.sdk.kotlin.services.sagemaker.model.SpaceSharingSettings
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateSpaceOperationSerializer: HttpSerializer.NonStreaming<CreateSpaceRequest> {
    override fun serialize(context: ExecutionContext, input: CreateSpaceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateSpaceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateSpaceOperationBody(context: ExecutionContext, input: CreateSpaceRequest): ByteArray {
    val serializer = JsonSerializer()
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainId"))
    val OWNERSHIPSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OwnershipSettings"))
    val SPACEDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceDisplayName"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpaceName"))
    val SPACESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SpaceSettings"))
    val SPACESHARINGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SpaceSharingSettings"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINID_DESCRIPTOR)
        field(OWNERSHIPSETTINGS_DESCRIPTOR)
        field(SPACEDISPLAYNAME_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
        field(SPACESETTINGS_DESCRIPTOR)
        field(SPACESHARINGSETTINGS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.domainId?.let { field(DOMAINID_DESCRIPTOR, it) }
        input.ownershipSettings?.let { field(OWNERSHIPSETTINGS_DESCRIPTOR, it, ::serializeOwnershipSettingsDocument) }
        input.spaceDisplayName?.let { field(SPACEDISPLAYNAME_DESCRIPTOR, it) }
        input.spaceName?.let { field(SPACENAME_DESCRIPTOR, it) }
        input.spaceSettings?.let { field(SPACESETTINGS_DESCRIPTOR, it, ::serializeSpaceSettingsDocument) }
        input.spaceSharingSettings?.let { field(SPACESHARINGSETTINGS_DESCRIPTOR, it, ::serializeSpaceSharingSettingsDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
