// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A collection of settings that apply to users in a domain. These settings are specified when the `CreateUserProfile` API is called, and as `DefaultUserSettings` when the `CreateDomain` API is called.
 *
 * `SecurityGroups` is aggregated when specified in both calls. For all other settings in `UserSettings`, the values specified in `CreateUserProfile` take precedence over those specified in `CreateDomain`.
 */
public class UserSettings private constructor(builder: Builder) {
    /**
     * Indicates whether auto-mounting of an EFS volume is supported for the user profile. The `DefaultAsDomain` value is only supported for user profiles. Do not use the `DefaultAsDomain` value when setting this parameter for a domain.
     *
     * SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.
     */
    public val autoMountHomeEfs: aws.sdk.kotlin.services.sagemaker.model.AutoMountHomeEfs? = builder.autoMountHomeEfs
    /**
     * The Canvas app settings.
     *
     * SageMaker applies these settings only to private spaces that SageMaker creates for the Canvas app.
     */
    public val canvasAppSettings: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings? = builder.canvasAppSettings
    /**
     * The Code Editor application settings.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val codeEditorAppSettings: aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppSettings? = builder.codeEditorAppSettings
    /**
     * The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker AI Studio.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val customFileSystemConfigs: List<CustomFileSystemConfig>? = builder.customFileSystemConfigs
    /**
     * Details about the POSIX identity that is used for file system operations.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val customPosixUserConfig: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig? = builder.customPosixUserConfig
    /**
     * The default experience that the user is directed to when accessing the domain. The supported values are:
     * + `studio::`: Indicates that Studio is the default experience. This value can only be passed if `StudioWebPortal` is set to `ENABLED`.
     * + `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
     */
    public val defaultLandingUri: kotlin.String? = builder.defaultLandingUri
    /**
     * The execution role for the user.
     *
     * SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * The settings for the JupyterLab application.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings? = builder.jupyterLabAppSettings
    /**
     * The Jupyter server's app settings.
     */
    public val jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = builder.jupyterServerAppSettings
    /**
     * The kernel gateway app settings.
     */
    public val kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = builder.kernelGatewayAppSettings
    /**
     * A collection of settings that configure the `RSessionGateway` app.
     */
    public val rSessionAppSettings: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings? = builder.rSessionAppSettings
    /**
     * A collection of settings that configure user interaction with the `RStudioServerPro` app.
     */
    public val rStudioServerProAppSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings? = builder.rStudioServerProAppSettings
    /**
     * The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
     *
     * Optional when the `CreateDomain.AppNetworkAccessType` parameter is set to `PublicInternetOnly`.
     *
     * Required when the `CreateDomain.AppNetworkAccessType` parameter is set to `VpcOnly`, unless specified as part of the `DefaultUserSettings` for the domain.
     *
     * Amazon SageMaker AI adds a security group to allow NFS traffic from Amazon SageMaker AI Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * Specifies options for sharing Amazon SageMaker AI Studio notebooks.
     */
    public val sharingSettings: aws.sdk.kotlin.services.sagemaker.model.SharingSettings? = builder.sharingSettings
    /**
     * The storage settings for a space.
     *
     * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
     */
    public val spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings? = builder.spaceStorageSettings
    /**
     * Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain.
     */
    public val studioWebPortal: aws.sdk.kotlin.services.sagemaker.model.StudioWebPortal? = builder.studioWebPortal
    /**
     * Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
     */
    public val studioWebPortalSettings: aws.sdk.kotlin.services.sagemaker.model.StudioWebPortalSettings? = builder.studioWebPortalSettings
    /**
     * The TensorBoard app settings.
     */
    public val tensorBoardAppSettings: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings? = builder.tensorBoardAppSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UserSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserSettings(")
        append("autoMountHomeEfs=$autoMountHomeEfs,")
        append("canvasAppSettings=$canvasAppSettings,")
        append("codeEditorAppSettings=$codeEditorAppSettings,")
        append("customFileSystemConfigs=$customFileSystemConfigs,")
        append("customPosixUserConfig=$customPosixUserConfig,")
        append("defaultLandingUri=$defaultLandingUri,")
        append("executionRole=$executionRole,")
        append("jupyterLabAppSettings=$jupyterLabAppSettings,")
        append("jupyterServerAppSettings=$jupyterServerAppSettings,")
        append("kernelGatewayAppSettings=$kernelGatewayAppSettings,")
        append("rSessionAppSettings=$rSessionAppSettings,")
        append("rStudioServerProAppSettings=$rStudioServerProAppSettings,")
        append("securityGroups=$securityGroups,")
        append("sharingSettings=$sharingSettings,")
        append("spaceStorageSettings=$spaceStorageSettings,")
        append("studioWebPortal=$studioWebPortal,")
        append("studioWebPortalSettings=$studioWebPortalSettings,")
        append("tensorBoardAppSettings=$tensorBoardAppSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMountHomeEfs?.hashCode() ?: 0
        result = 31 * result + (canvasAppSettings?.hashCode() ?: 0)
        result = 31 * result + (codeEditorAppSettings?.hashCode() ?: 0)
        result = 31 * result + (customFileSystemConfigs?.hashCode() ?: 0)
        result = 31 * result + (customPosixUserConfig?.hashCode() ?: 0)
        result = 31 * result + (defaultLandingUri?.hashCode() ?: 0)
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (jupyterLabAppSettings?.hashCode() ?: 0)
        result = 31 * result + (jupyterServerAppSettings?.hashCode() ?: 0)
        result = 31 * result + (kernelGatewayAppSettings?.hashCode() ?: 0)
        result = 31 * result + (rSessionAppSettings?.hashCode() ?: 0)
        result = 31 * result + (rStudioServerProAppSettings?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sharingSettings?.hashCode() ?: 0)
        result = 31 * result + (spaceStorageSettings?.hashCode() ?: 0)
        result = 31 * result + (studioWebPortal?.hashCode() ?: 0)
        result = 31 * result + (studioWebPortalSettings?.hashCode() ?: 0)
        result = 31 * result + (tensorBoardAppSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserSettings

        if (autoMountHomeEfs != other.autoMountHomeEfs) return false
        if (canvasAppSettings != other.canvasAppSettings) return false
        if (codeEditorAppSettings != other.codeEditorAppSettings) return false
        if (customFileSystemConfigs != other.customFileSystemConfigs) return false
        if (customPosixUserConfig != other.customPosixUserConfig) return false
        if (defaultLandingUri != other.defaultLandingUri) return false
        if (executionRole != other.executionRole) return false
        if (jupyterLabAppSettings != other.jupyterLabAppSettings) return false
        if (jupyterServerAppSettings != other.jupyterServerAppSettings) return false
        if (kernelGatewayAppSettings != other.kernelGatewayAppSettings) return false
        if (rSessionAppSettings != other.rSessionAppSettings) return false
        if (rStudioServerProAppSettings != other.rStudioServerProAppSettings) return false
        if (securityGroups != other.securityGroups) return false
        if (sharingSettings != other.sharingSettings) return false
        if (spaceStorageSettings != other.spaceStorageSettings) return false
        if (studioWebPortal != other.studioWebPortal) return false
        if (studioWebPortalSettings != other.studioWebPortalSettings) return false
        if (tensorBoardAppSettings != other.tensorBoardAppSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UserSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether auto-mounting of an EFS volume is supported for the user profile. The `DefaultAsDomain` value is only supported for user profiles. Do not use the `DefaultAsDomain` value when setting this parameter for a domain.
         *
         * SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.
         */
        public var autoMountHomeEfs: aws.sdk.kotlin.services.sagemaker.model.AutoMountHomeEfs? = null
        /**
         * The Canvas app settings.
         *
         * SageMaker applies these settings only to private spaces that SageMaker creates for the Canvas app.
         */
        public var canvasAppSettings: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings? = null
        /**
         * The Code Editor application settings.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var codeEditorAppSettings: aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppSettings? = null
        /**
         * The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker AI Studio.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var customFileSystemConfigs: List<CustomFileSystemConfig>? = null
        /**
         * Details about the POSIX identity that is used for file system operations.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var customPosixUserConfig: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig? = null
        /**
         * The default experience that the user is directed to when accessing the domain. The supported values are:
         * + `studio::`: Indicates that Studio is the default experience. This value can only be passed if `StudioWebPortal` is set to `ENABLED`.
         * + `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
         */
        public var defaultLandingUri: kotlin.String? = null
        /**
         * The execution role for the user.
         *
         * SageMaker applies this setting only to private spaces that the user creates in the domain. SageMaker doesn't apply this setting to shared spaces.
         */
        public var executionRole: kotlin.String? = null
        /**
         * The settings for the JupyterLab application.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var jupyterLabAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings? = null
        /**
         * The Jupyter server's app settings.
         */
        public var jupyterServerAppSettings: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings? = null
        /**
         * The kernel gateway app settings.
         */
        public var kernelGatewayAppSettings: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings? = null
        /**
         * A collection of settings that configure the `RSessionGateway` app.
         */
        public var rSessionAppSettings: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings? = null
        /**
         * A collection of settings that configure user interaction with the `RStudioServerPro` app.
         */
        public var rStudioServerProAppSettings: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings? = null
        /**
         * The security groups for the Amazon Virtual Private Cloud (VPC) that the domain uses for communication.
         *
         * Optional when the `CreateDomain.AppNetworkAccessType` parameter is set to `PublicInternetOnly`.
         *
         * Required when the `CreateDomain.AppNetworkAccessType` parameter is set to `VpcOnly`, unless specified as part of the `DefaultUserSettings` for the domain.
         *
         * Amazon SageMaker AI adds a security group to allow NFS traffic from Amazon SageMaker AI Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var securityGroups: List<String>? = null
        /**
         * Specifies options for sharing Amazon SageMaker AI Studio notebooks.
         */
        public var sharingSettings: aws.sdk.kotlin.services.sagemaker.model.SharingSettings? = null
        /**
         * The storage settings for a space.
         *
         * SageMaker applies these settings only to private spaces that the user creates in the domain. SageMaker doesn't apply these settings to shared spaces.
         */
        public var spaceStorageSettings: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings? = null
        /**
         * Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain.
         */
        public var studioWebPortal: aws.sdk.kotlin.services.sagemaker.model.StudioWebPortal? = null
        /**
         * Studio settings. If these settings are applied on a user level, they take priority over the settings applied on a domain level.
         */
        public var studioWebPortalSettings: aws.sdk.kotlin.services.sagemaker.model.StudioWebPortalSettings? = null
        /**
         * The TensorBoard app settings.
         */
        public var tensorBoardAppSettings: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UserSettings) : this() {
            this.autoMountHomeEfs = x.autoMountHomeEfs
            this.canvasAppSettings = x.canvasAppSettings
            this.codeEditorAppSettings = x.codeEditorAppSettings
            this.customFileSystemConfigs = x.customFileSystemConfigs
            this.customPosixUserConfig = x.customPosixUserConfig
            this.defaultLandingUri = x.defaultLandingUri
            this.executionRole = x.executionRole
            this.jupyterLabAppSettings = x.jupyterLabAppSettings
            this.jupyterServerAppSettings = x.jupyterServerAppSettings
            this.kernelGatewayAppSettings = x.kernelGatewayAppSettings
            this.rSessionAppSettings = x.rSessionAppSettings
            this.rStudioServerProAppSettings = x.rStudioServerProAppSettings
            this.securityGroups = x.securityGroups
            this.sharingSettings = x.sharingSettings
            this.spaceStorageSettings = x.spaceStorageSettings
            this.studioWebPortal = x.studioWebPortal
            this.studioWebPortalSettings = x.studioWebPortalSettings
            this.tensorBoardAppSettings = x.tensorBoardAppSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UserSettings = UserSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings] inside the given [block]
         */
        public fun canvasAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings.Builder.() -> kotlin.Unit) {
            this.canvasAppSettings = aws.sdk.kotlin.services.sagemaker.model.CanvasAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppSettings] inside the given [block]
         */
        public fun codeEditorAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppSettings.Builder.() -> kotlin.Unit) {
            this.codeEditorAppSettings = aws.sdk.kotlin.services.sagemaker.model.CodeEditorAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig] inside the given [block]
         */
        public fun customPosixUserConfig(block: aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig.Builder.() -> kotlin.Unit) {
            this.customPosixUserConfig = aws.sdk.kotlin.services.sagemaker.model.CustomPosixUserConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings] inside the given [block]
         */
        public fun jupyterLabAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterLabAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterLabAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings] inside the given [block]
         */
        public fun jupyterServerAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.Builder.() -> kotlin.Unit) {
            this.jupyterServerAppSettings = aws.sdk.kotlin.services.sagemaker.model.JupyterServerAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings] inside the given [block]
         */
        public fun kernelGatewayAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.Builder.() -> kotlin.Unit) {
            this.kernelGatewayAppSettings = aws.sdk.kotlin.services.sagemaker.model.KernelGatewayAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings] inside the given [block]
         */
        public fun rSessionAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings.Builder.() -> kotlin.Unit) {
            this.rSessionAppSettings = aws.sdk.kotlin.services.sagemaker.model.RSessionAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings] inside the given [block]
         */
        public fun rStudioServerProAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings.Builder.() -> kotlin.Unit) {
            this.rStudioServerProAppSettings = aws.sdk.kotlin.services.sagemaker.model.RStudioServerProAppSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SharingSettings] inside the given [block]
         */
        public fun sharingSettings(block: aws.sdk.kotlin.services.sagemaker.model.SharingSettings.Builder.() -> kotlin.Unit) {
            this.sharingSettings = aws.sdk.kotlin.services.sagemaker.model.SharingSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings] inside the given [block]
         */
        public fun spaceStorageSettings(block: aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings.Builder.() -> kotlin.Unit) {
            this.spaceStorageSettings = aws.sdk.kotlin.services.sagemaker.model.DefaultSpaceStorageSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StudioWebPortalSettings] inside the given [block]
         */
        public fun studioWebPortalSettings(block: aws.sdk.kotlin.services.sagemaker.model.StudioWebPortalSettings.Builder.() -> kotlin.Unit) {
            this.studioWebPortalSettings = aws.sdk.kotlin.services.sagemaker.model.StudioWebPortalSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings] inside the given [block]
         */
        public fun tensorBoardAppSettings(block: aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings.Builder.() -> kotlin.Unit) {
            this.tensorBoardAppSettings = aws.sdk.kotlin.services.sagemaker.model.TensorBoardAppSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
