// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateFeatureGroupRequest private constructor(builder: Builder) {
    /**
     * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200 response, you've made a valid request. It takes some time after you've made a valid request for Feature Store to update the feature group.
     */
    public val featureAdditions: List<FeatureDefinition>? = builder.featureAdditions
    /**
     * The name or Amazon Resource Name (ARN) of the feature group that you're updating.
     */
    public val featureGroupName: kotlin.String? = builder.featureGroupName
    /**
     * Updates the feature group online store configuration.
     */
    public val onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfigUpdate? = builder.onlineStoreConfig
    /**
     * The new throughput configuration for the feature group. You can switch between on-demand and provisioned modes or update the read / write capacity of provisioned feature groups. You can switch a feature group to on-demand only once in a 24 hour period.
     */
    public val throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate? = builder.throughputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.UpdateFeatureGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFeatureGroupRequest(")
        append("featureAdditions=$featureAdditions,")
        append("featureGroupName=$featureGroupName,")
        append("onlineStoreConfig=$onlineStoreConfig,")
        append("throughputConfig=$throughputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureAdditions?.hashCode() ?: 0
        result = 31 * result + (featureGroupName?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (throughputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFeatureGroupRequest

        if (featureAdditions != other.featureAdditions) return false
        if (featureGroupName != other.featureGroupName) return false
        if (onlineStoreConfig != other.onlineStoreConfig) return false
        if (throughputConfig != other.throughputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.UpdateFeatureGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Updates the feature group. Updating a feature group is an asynchronous operation. When you get an HTTP 200 response, you've made a valid request. It takes some time after you've made a valid request for Feature Store to update the feature group.
         */
        public var featureAdditions: List<FeatureDefinition>? = null
        /**
         * The name or Amazon Resource Name (ARN) of the feature group that you're updating.
         */
        public var featureGroupName: kotlin.String? = null
        /**
         * Updates the feature group online store configuration.
         */
        public var onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfigUpdate? = null
        /**
         * The new throughput configuration for the feature group. You can switch between on-demand and provisioned modes or update the read / write capacity of provisioned feature groups. You can switch a feature group to on-demand only once in a 24 hour period.
         */
        public var throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.UpdateFeatureGroupRequest) : this() {
            this.featureAdditions = x.featureAdditions
            this.featureGroupName = x.featureGroupName
            this.onlineStoreConfig = x.onlineStoreConfig
            this.throughputConfig = x.throughputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.UpdateFeatureGroupRequest = UpdateFeatureGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfigUpdate] inside the given [block]
         */
        public fun onlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfigUpdate.Builder.() -> kotlin.Unit) {
            this.onlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfigUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate] inside the given [block]
         */
        public fun throughputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate.Builder.() -> kotlin.Unit) {
            this.throughputConfig = aws.sdk.kotlin.services.sagemaker.model.ThroughputConfigUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
