// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import kotlin.collections.List

/**
 * The training input mode that the algorithm supports. For more information about input modes, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
 *
 * **Pipe mode**
 *
 * If an algorithm supports `Pipe` mode, Amazon SageMaker streams data directly from Amazon S3 to the container.
 *
 * **File mode**
 *
 * If an algorithm supports `File` mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.
 *
 * You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.
 *
 * For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.
 *
 * **FastFile mode**
 *
 * If an algorithm supports `FastFile` mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.
 *
 * `FastFile` mode works best when the data is read sequentially. Augmented manifest files aren't supported. The startup time is lower when there are fewer files in the S3 bucket provided.
 */
public sealed class TrainingInputMode {
    public abstract val value: kotlin.String

    public object Fastfile : aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode() {
        override val value: kotlin.String = "FastFile"
        override fun toString(): kotlin.String = "Fastfile"
    }

    public object File : aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode() {
        override val value: kotlin.String = "File"
        override fun toString(): kotlin.String = "File"
    }

    public object Pipe : aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode() {
        override val value: kotlin.String = "Pipe"
        override fun toString(): kotlin.String = "Pipe"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode = when (value) {
            "FastFile" -> Fastfile
            "File" -> File
            "Pipe" -> Pipe
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode> = listOf(
            Fastfile,
            File,
            Pipe,
        )
    }
}
