// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Time series forecast settings for the SageMaker Canvas application.
 */
public class TimeSeriesForecastingSettings private constructor(builder: Builder) {
    /**
     * The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses the execution role specified in the `UserProfile` that launches the Canvas application. If an execution role is not specified in the `UserProfile`, Canvas uses the execution role specified in the Domain that owns the `UserProfile`. To allow time series forecasting, this IAM role should have the [ AmazonSageMakerCanvasForecastAccess](https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess) policy attached and `forecast.amazonaws.com` added in the trust relationship as a service principal.
     */
    public val amazonForecastRoleArn: kotlin.String? = builder.amazonForecastRoleArn
    /**
     * Describes whether time series forecasting is enabled or disabled in the Canvas application.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.FeatureStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimeSeriesForecastingSettings(")
        append("amazonForecastRoleArn=$amazonForecastRoleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonForecastRoleArn?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimeSeriesForecastingSettings

        if (amazonForecastRoleArn != other.amazonForecastRoleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IAM role that Canvas passes to Amazon Forecast for time series forecasting. By default, Canvas uses the execution role specified in the `UserProfile` that launches the Canvas application. If an execution role is not specified in the `UserProfile`, Canvas uses the execution role specified in the Domain that owns the `UserProfile`. To allow time series forecasting, this IAM role should have the [ AmazonSageMakerCanvasForecastAccess](https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess) policy attached and `forecast.amazonaws.com` added in the trust relationship as a service principal.
         */
        public var amazonForecastRoleArn: kotlin.String? = null
        /**
         * Describes whether time series forecasting is enabled or disabled in the Canvas application.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.FeatureStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingSettings) : this() {
            this.amazonForecastRoleArn = x.amazonForecastRoleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.TimeSeriesForecastingSettings = TimeSeriesForecastingSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
