// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to log in to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.
 */
public class SourceIpConfig private constructor(builder: Builder) {
    /**
     * A list of one to ten [Classless Inter-Domain Routing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) (CIDR) values.
     *
     * Maximum: Ten CIDR values
     *
     * The following Length Constraints apply to individual CIDR values in the CIDR value list.
     */
    public val cidrs: List<String>? = builder.cidrs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceIpConfig(")
        append("cidrs=$cidrs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrs?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceIpConfig

        if (cidrs != other.cidrs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of one to ten [Classless Inter-Domain Routing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) (CIDR) values.
         *
         * Maximum: Ten CIDR values
         *
         * The following Length Constraints apply to individual CIDR values in the CIDR value list.
         */
        public var cidrs: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig) : this() {
            this.cidrs = x.cidrs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SourceIpConfig = SourceIpConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
