// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchRequest private constructor(builder: Builder) {
    /**
     * A cross account filter option. When the value is `"CrossAccount"` the search results will only include resources made discoverable to you from other accounts. When the value is `"SameAccount"` or `null` the search results will only include resources from your account. Default is `null`. For more information on searching for resources made discoverable to your account, see [ Search discoverable resources](https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html) in the SageMaker Developer Guide. The maximum number of `ResourceCatalog`s viewable is 1000.
     */
    public val crossAccountFilterOption: aws.sdk.kotlin.services.sagemaker.model.CrossAccountFilterOption? = builder.crossAccountFilterOption
    /**
     * The maximum number of results to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If more than `MaxResults` resources match the specified `SearchExpression`, the response includes a `NextToken`. The `NextToken` can be passed to the next `SearchRequest` to continue retrieving results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the SageMaker resource to search for.
     */
    public val resource: aws.sdk.kotlin.services.sagemaker.model.ResourceType? = builder.resource
    /**
     * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive `SubExpressions`, `NestedFilters`, and `Filters` that can be included in a `SearchExpression` object is 50.
     */
    public val searchExpression: aws.sdk.kotlin.services.sagemaker.model.SearchExpression? = builder.searchExpression
    /**
     * The name of the resource property used to sort the `SearchResults`. The default is `LastModifiedTime`.
     */
    public val sortBy: kotlin.String? = builder.sortBy
    /**
     * How `SearchResults` are ordered. Valid values are `Ascending` or `Descending`. The default is `Descending`.
     */
    public val sortOrder: aws.sdk.kotlin.services.sagemaker.model.SearchSortOrder? = builder.sortOrder
    /**
     * Limits the results of your search request to the resources that you can access.
     */
    public val visibilityConditions: List<VisibilityConditions>? = builder.visibilityConditions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchRequest(")
        append("crossAccountFilterOption=$crossAccountFilterOption,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("resource=$resource,")
        append("searchExpression=$searchExpression,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder,")
        append("visibilityConditions=$visibilityConditions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = crossAccountFilterOption?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        result = 31 * result + (searchExpression?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        result = 31 * result + (visibilityConditions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchRequest

        if (crossAccountFilterOption != other.crossAccountFilterOption) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (resource != other.resource) return false
        if (searchExpression != other.searchExpression) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false
        if (visibilityConditions != other.visibilityConditions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A cross account filter option. When the value is `"CrossAccount"` the search results will only include resources made discoverable to you from other accounts. When the value is `"SameAccount"` or `null` the search results will only include resources from your account. Default is `null`. For more information on searching for resources made discoverable to your account, see [ Search discoverable resources](https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-cross-account-discoverability-use.html) in the SageMaker Developer Guide. The maximum number of `ResourceCatalog`s viewable is 1000.
         */
        public var crossAccountFilterOption: aws.sdk.kotlin.services.sagemaker.model.CrossAccountFilterOption? = null
        /**
         * The maximum number of results to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If more than `MaxResults` resources match the specified `SearchExpression`, the response includes a `NextToken`. The `NextToken` can be passed to the next `SearchRequest` to continue retrieving results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the SageMaker resource to search for.
         */
        public var resource: aws.sdk.kotlin.services.sagemaker.model.ResourceType? = null
        /**
         * A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive `SubExpressions`, `NestedFilters`, and `Filters` that can be included in a `SearchExpression` object is 50.
         */
        public var searchExpression: aws.sdk.kotlin.services.sagemaker.model.SearchExpression? = null
        /**
         * The name of the resource property used to sort the `SearchResults`. The default is `LastModifiedTime`.
         */
        public var sortBy: kotlin.String? = null
        /**
         * How `SearchResults` are ordered. Valid values are `Ascending` or `Descending`. The default is `Descending`.
         */
        public var sortOrder: aws.sdk.kotlin.services.sagemaker.model.SearchSortOrder? = null
        /**
         * Limits the results of your search request to the resources that you can access.
         */
        public var visibilityConditions: List<VisibilityConditions>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SearchRequest) : this() {
            this.crossAccountFilterOption = x.crossAccountFilterOption
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.resource = x.resource
            this.searchExpression = x.searchExpression
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
            this.visibilityConditions = x.visibilityConditions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SearchRequest = SearchRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SearchExpression] inside the given [block]
         */
        public fun searchExpression(block: aws.sdk.kotlin.services.sagemaker.model.SearchExpression.Builder.() -> kotlin.Unit) {
            this.searchExpression = aws.sdk.kotlin.services.sagemaker.model.SearchExpression.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
