// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Cluster policy configuration. This policy is used for task prioritization and fair-share allocation. This helps prioritize critical workloads and distributes idle compute across entities.
 */
public class SchedulerConfig private constructor(builder: Builder) {
    /**
     * When enabled, entities borrow idle compute based on their assigned `FairShareWeight`.
     *
     * When disabled, entities borrow idle compute based on a first-come first-serve basis.
     *
     * Default is `Enabled`.
     */
    public val fairShare: aws.sdk.kotlin.services.sagemaker.model.FairShare? = builder.fairShare
    /**
     * List of the priority classes, `PriorityClass`, of the cluster policy. When specified, these class configurations define how tasks are queued.
     */
    public val priorityClasses: List<PriorityClass>? = builder.priorityClasses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.SchedulerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchedulerConfig(")
        append("fairShare=$fairShare,")
        append("priorityClasses=$priorityClasses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fairShare?.hashCode() ?: 0
        result = 31 * result + (priorityClasses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchedulerConfig

        if (fairShare != other.fairShare) return false
        if (priorityClasses != other.priorityClasses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.SchedulerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When enabled, entities borrow idle compute based on their assigned `FairShareWeight`.
         *
         * When disabled, entities borrow idle compute based on a first-come first-serve basis.
         *
         * Default is `Enabled`.
         */
        public var fairShare: aws.sdk.kotlin.services.sagemaker.model.FairShare? = null
        /**
         * List of the priority classes, `PriorityClass`, of the cluster policy. When specified, these class configurations define how tasks are queued.
         */
        public var priorityClasses: List<PriorityClass>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.SchedulerConfig) : this() {
            this.fairShare = x.fairShare
            this.priorityClasses = x.priorityClasses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.SchedulerConfig = SchedulerConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
