// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the ARN's of a SageMaker AI image and SageMaker AI image version, and the instance type that the version runs on.
 */
public class ResourceSpec private constructor(builder: Builder) {
    /**
     * The instance type that the image version runs on.
     *
     * **JupyterServer apps** only support the `system` value.
     *
     * For **KernelGateway apps**, the `system` value is translated to `ml.t3.medium`. KernelGateway apps also support all other values for available instance types.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.AppInstanceType? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    public val lifecycleConfigArn: kotlin.String? = builder.lifecycleConfigArn
    /**
     * The ARN of the SageMaker AI image that the image version belongs to.
     */
    public val sageMakerImageArn: kotlin.String? = builder.sageMakerImageArn
    /**
     * The SageMakerImageVersionAlias of the image to launch with. This value is in SemVer 2.0.0 versioning format.
     */
    public val sageMakerImageVersionAlias: kotlin.String? = builder.sageMakerImageVersionAlias
    /**
     * The ARN of the image version created on the instance.
     */
    public val sageMakerImageVersionArn: kotlin.String? = builder.sageMakerImageVersionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSpec(")
        append("instanceType=$instanceType,")
        append("lifecycleConfigArn=$lifecycleConfigArn,")
        append("sageMakerImageArn=$sageMakerImageArn,")
        append("sageMakerImageVersionAlias=$sageMakerImageVersionAlias,")
        append("sageMakerImageVersionArn=$sageMakerImageVersionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (lifecycleConfigArn?.hashCode() ?: 0)
        result = 31 * result + (sageMakerImageArn?.hashCode() ?: 0)
        result = 31 * result + (sageMakerImageVersionAlias?.hashCode() ?: 0)
        result = 31 * result + (sageMakerImageVersionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSpec

        if (instanceType != other.instanceType) return false
        if (lifecycleConfigArn != other.lifecycleConfigArn) return false
        if (sageMakerImageArn != other.sageMakerImageArn) return false
        if (sageMakerImageVersionAlias != other.sageMakerImageVersionAlias) return false
        if (sageMakerImageVersionArn != other.sageMakerImageVersionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instance type that the image version runs on.
         *
         * **JupyterServer apps** only support the `system` value.
         *
         * For **KernelGateway apps**, the `system` value is translated to `ml.t3.medium`. KernelGateway apps also support all other values for available instance types.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.AppInstanceType? = null
        /**
         * The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
         */
        public var lifecycleConfigArn: kotlin.String? = null
        /**
         * The ARN of the SageMaker AI image that the image version belongs to.
         */
        public var sageMakerImageArn: kotlin.String? = null
        /**
         * The SageMakerImageVersionAlias of the image to launch with. This value is in SemVer 2.0.0 versioning format.
         */
        public var sageMakerImageVersionAlias: kotlin.String? = null
        /**
         * The ARN of the image version created on the instance.
         */
        public var sageMakerImageVersionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec) : this() {
            this.instanceType = x.instanceType
            this.lifecycleConfigArn = x.lifecycleConfigArn
            this.sageMakerImageArn = x.sageMakerImageArn
            this.sageMakerImageVersionAlias = x.sageMakerImageVersionAlias
            this.sageMakerImageVersionArn = x.sageMakerImageVersionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ResourceSpec = ResourceSpec(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
