// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Resource sharing configuration.
 */
public class ResourceSharingConfig private constructor(builder: Builder) {
    /**
     * The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute that the team is allowed to borrow.
     *
     * Default is `50`.
     */
    public val borrowLimit: kotlin.Int? = builder.borrowLimit
    /**
     * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
     * + `DontLend`: entities do not lend idle compute.
     * + `Lend`: entities can lend idle compute to entities that can borrow.
     * + `LendandBorrow`: entities can lend idle compute and borrow idle compute from other entities.
     *
     * Default is `LendandBorrow`.
     */
    public val strategy: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingStrategy? = builder.strategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSharingConfig(")
        append("borrowLimit=$borrowLimit,")
        append("strategy=$strategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = borrowLimit ?: 0
        result = 31 * result + (strategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSharingConfig

        if (borrowLimit != other.borrowLimit) return false
        if (strategy != other.strategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The limit on how much idle compute can be borrowed.The values can be 1 - 500 percent of idle compute that the team is allowed to borrow.
         *
         * Default is `50`.
         */
        public var borrowLimit: kotlin.Int? = null
        /**
         * The strategy of how idle compute is shared within the cluster. The following are the options of strategies.
         * + `DontLend`: entities do not lend idle compute.
         * + `Lend`: entities can lend idle compute to entities that can borrow.
         * + `LendandBorrow`: entities can lend idle compute and borrow idle compute from other entities.
         *
         * Default is `LendandBorrow`.
         */
        public var strategy: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig) : this() {
            this.borrowLimit = x.borrowLimit
            this.strategy = x.strategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig = ResourceSharingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
