// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration settings for the SageMaker Partner AI App.
 */
public class PartnerAppConfig private constructor(builder: Builder) {
    /**
     * The list of users that are given admin access to the SageMaker Partner AI App.
     */
    public val adminUsers: List<String>? = builder.adminUsers
    /**
     * This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the map is populated with a key and value pair that is specific to the user and application.
     */
    public val arguments: Map<String, String>? = builder.arguments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.PartnerAppConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PartnerAppConfig(")
        append("adminUsers=$adminUsers,")
        append("arguments=$arguments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminUsers?.hashCode() ?: 0
        result = 31 * result + (arguments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PartnerAppConfig

        if (adminUsers != other.adminUsers) return false
        if (arguments != other.arguments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.PartnerAppConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of users that are given admin access to the SageMaker Partner AI App.
         */
        public var adminUsers: List<String>? = null
        /**
         * This is a map of required inputs for a SageMaker Partner AI App. Based on the application type, the map is populated with a key and value pair that is specific to the user and application.
         */
        public var arguments: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.PartnerAppConfig) : this() {
            this.adminUsers = x.adminUsers
            this.arguments = x.arguments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.PartnerAppConfig = PartnerAppConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
