// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an `OfflineStore`.
 *
 * Provide an `OfflineStoreConfig` in a request to `CreateFeatureGroup` to create an `OfflineStore`.
 *
 * To encrypt an `OfflineStore` using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or `KMSKeyId`, in `S3StorageConfig`.
 */
public class OfflineStoreConfig private constructor(builder: Builder) {
    /**
     * The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
     */
    public val dataCatalogConfig: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig? = builder.dataCatalogConfig
    /**
     * Set to `True` to disable the automatic creation of an Amazon Web Services Glue table when configuring an `OfflineStore`. If set to `False`, Feature Store will name the `OfflineStore` Glue table following [Athena's naming recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html).
     *
     * The default value is `False`.
     */
    public val disableGlueTableCreation: kotlin.Boolean? = builder.disableGlueTableCreation
    /**
     * The Amazon Simple Storage (Amazon S3) location of `OfflineStore`.
     */
    public val s3StorageConfig: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig? = builder.s3StorageConfig
    /**
     * Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://iceberg.apache.org/).
     */
    public val tableFormat: aws.sdk.kotlin.services.sagemaker.model.TableFormat? = builder.tableFormat

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OfflineStoreConfig(")
        append("dataCatalogConfig=$dataCatalogConfig,")
        append("disableGlueTableCreation=$disableGlueTableCreation,")
        append("s3StorageConfig=$s3StorageConfig,")
        append("tableFormat=$tableFormat")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataCatalogConfig?.hashCode() ?: 0
        result = 31 * result + (disableGlueTableCreation?.hashCode() ?: 0)
        result = 31 * result + (s3StorageConfig?.hashCode() ?: 0)
        result = 31 * result + (tableFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OfflineStoreConfig

        if (dataCatalogConfig != other.dataCatalogConfig) return false
        if (disableGlueTableCreation != other.disableGlueTableCreation) return false
        if (s3StorageConfig != other.s3StorageConfig) return false
        if (tableFormat != other.tableFormat) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The meta data of the Glue table that is autogenerated when an `OfflineStore` is created.
         */
        public var dataCatalogConfig: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig? = null
        /**
         * Set to `True` to disable the automatic creation of an Amazon Web Services Glue table when configuring an `OfflineStore`. If set to `False`, Feature Store will name the `OfflineStore` Glue table following [Athena's naming recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html).
         *
         * The default value is `False`.
         */
        public var disableGlueTableCreation: kotlin.Boolean? = null
        /**
         * The Amazon Simple Storage (Amazon S3) location of `OfflineStore`.
         */
        public var s3StorageConfig: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig? = null
        /**
         * Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://iceberg.apache.org/).
         */
        public var tableFormat: aws.sdk.kotlin.services.sagemaker.model.TableFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig) : this() {
            this.dataCatalogConfig = x.dataCatalogConfig
            this.disableGlueTableCreation = x.disableGlueTableCreation
            this.s3StorageConfig = x.s3StorageConfig
            this.tableFormat = x.tableFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig = OfflineStoreConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig] inside the given [block]
         */
        public fun dataCatalogConfig(block: aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig.Builder.() -> kotlin.Unit) {
            this.dataCatalogConfig = aws.sdk.kotlin.services.sagemaker.model.DataCatalogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig] inside the given [block]
         */
        public fun s3StorageConfig(block: aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig.Builder.() -> kotlin.Unit) {
            this.s3StorageConfig = aws.sdk.kotlin.services.sagemaker.model.S3StorageConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
