// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration for the cluster used to run model monitoring jobs.
 */
public class MonitoringClusterConfig private constructor(builder: Builder) {
    /**
     * The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The ML compute instance type for the processing job.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = builder.instanceType
    /**
     * The Key Management Service (KMS) key that Amazon SageMaker AI uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringClusterConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringClusterConfig(")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceCount ?: 0
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringClusterConfig

        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringClusterConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The ML compute instance type for the processing job.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = null
        /**
         * The Key Management Service (KMS) key that Amazon SageMaker AI uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringClusterConfig) : this() {
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringClusterConfig = MonitoringClusterConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
