// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The model card associated with the model package. Since `ModelPackageModelCard` is tied to a model package, it is a specific usage of a model card and its schema is simplified compared to the schema of `ModelCard`. The `ModelPackageModelCard` schema does not include `model_package_details`, and `model_overview` is composed of the `model_creator` and `model_artifact` properties. For more information about the model package model card schema, see [Model package model card schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema). For more information about the model card associated with the model package, see [View the Details of a Model Version](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html).
 */
public class ModelPackageModelCard private constructor(builder: Builder) {
    /**
     * The content of the model card. The content must follow the schema described in [Model Package Model Card Schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema).
     */
    public val modelCardContent: kotlin.String? = builder.modelCardContent
    /**
     * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates can be made to the model card content. If you try to update the model card content, you will receive the message `Model Card is in Archived state`.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackageModelCard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackageModelCard(")
        append("modelCardContent=*** Sensitive Data Redacted ***,")
        append("modelCardStatus=$modelCardStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = modelCardContent?.hashCode() ?: 0
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackageModelCard

        if (modelCardContent != other.modelCardContent) return false
        if (modelCardStatus != other.modelCardStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackageModelCard = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content of the model card. The content must follow the schema described in [Model Package Model Card Schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-registry-details.html#model-card-schema).
         */
        public var modelCardContent: kotlin.String? = null
        /**
         * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates can be made to the model card content. If you try to update the model card content, you will receive the message `Model Card is in Archived state`.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackageModelCard) : this() {
            this.modelCardContent = x.modelCardContent
            this.modelCardStatus = x.modelCardStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackageModelCard = ModelPackageModelCard(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
