// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The model card for a model displayed in the Amazon SageMaker Model Dashboard.
 */
public class ModelDashboardModelCard private constructor(builder: Builder) {
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * A timestamp that indicates when the model card was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * A timestamp that indicates when the model card was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) for a model card.
     */
    public val modelCardArn: kotlin.String? = builder.modelCardArn
    /**
     * The name of a model card.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The model card status.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus
    /**
     * The model card version.
     */
    public val modelCardVersion: kotlin.Int? = builder.modelCardVersion
    /**
     * For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this is a user-customized string.
     */
    public val modelId: kotlin.String? = builder.modelId
    /**
     * A model card's risk rating. Can be low, medium, or high.
     */
    public val riskRating: kotlin.String? = builder.riskRating
    /**
     * The KMS Key ID (`KMSKeyId`) for encryption of model card information.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = builder.securityConfig
    /**
     * The tags associated with a model card.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardModelCard = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelDashboardModelCard(")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelCardArn=$modelCardArn,")
        append("modelCardName=$modelCardName,")
        append("modelCardStatus=$modelCardStatus,")
        append("modelCardVersion=$modelCardVersion,")
        append("modelId=$modelId,")
        append("riskRating=$riskRating,")
        append("securityConfig=$securityConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdBy?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelCardArn?.hashCode() ?: 0)
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        result = 31 * result + (modelCardVersion ?: 0)
        result = 31 * result + (modelId?.hashCode() ?: 0)
        result = 31 * result + (riskRating?.hashCode() ?: 0)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelDashboardModelCard

        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelCardArn != other.modelCardArn) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardStatus != other.modelCardStatus) return false
        if (modelCardVersion != other.modelCardVersion) return false
        if (modelId != other.modelId) return false
        if (riskRating != other.riskRating) return false
        if (securityConfig != other.securityConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardModelCard = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * A timestamp that indicates when the model card was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, project, or model card.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * A timestamp that indicates when the model card was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for a model card.
         */
        public var modelCardArn: kotlin.String? = null
        /**
         * The name of a model card.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The model card status.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null
        /**
         * The model card version.
         */
        public var modelCardVersion: kotlin.Int? = null
        /**
         * For models created in SageMaker, this is the model ARN. For models created outside of SageMaker, this is a user-customized string.
         */
        public var modelId: kotlin.String? = null
        /**
         * A model card's risk rating. Can be low, medium, or high.
         */
        public var riskRating: kotlin.String? = null
        /**
         * The KMS Key ID (`KMSKeyId`) for encryption of model card information.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = null
        /**
         * The tags associated with a model card.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelDashboardModelCard) : this() {
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.modelCardArn = x.modelCardArn
            this.modelCardName = x.modelCardName
            this.modelCardStatus = x.modelCardStatus
            this.modelCardVersion = x.modelCardVersion
            this.modelId = x.modelId
            this.riskRating = x.riskRating
            this.securityConfig = x.securityConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelDashboardModelCard = ModelDashboardModelCard(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
