// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the location of input data.
 *
 * You must specify at least one of the following: `S3DataSource` or `SnsDataSource`.
 *
 * Use `SnsDataSource` to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job.
 *
 * Use `S3DataSource` to specify an input manifest file for both streaming and one-time labeling jobs. Adding an `S3DataSource` is optional if you use `SnsDataSource` to create a streaming labeling job.
 */
public class LabelingJobDataSource private constructor(builder: Builder) {
    /**
     * The Amazon S3 location of the input data objects.
     */
    public val s3DataSource: aws.sdk.kotlin.services.sagemaker.model.LabelingJobS3DataSource? = builder.s3DataSource
    /**
     * An Amazon SNS data source used for streaming labeling jobs. To learn more, see [Send Data to a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data).
     */
    public val snsDataSource: aws.sdk.kotlin.services.sagemaker.model.LabelingJobSnsDataSource? = builder.snsDataSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobDataSource(")
        append("s3DataSource=$s3DataSource,")
        append("snsDataSource=$snsDataSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3DataSource?.hashCode() ?: 0
        result = 31 * result + (snsDataSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobDataSource

        if (s3DataSource != other.s3DataSource) return false
        if (snsDataSource != other.snsDataSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobDataSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 location of the input data objects.
         */
        public var s3DataSource: aws.sdk.kotlin.services.sagemaker.model.LabelingJobS3DataSource? = null
        /**
         * An Amazon SNS data source used for streaming labeling jobs. To learn more, see [Send Data to a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data).
         */
        public var snsDataSource: aws.sdk.kotlin.services.sagemaker.model.LabelingJobSnsDataSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobDataSource) : this() {
            this.s3DataSource = x.s3DataSource
            this.snsDataSource = x.snsDataSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobDataSource = LabelingJobDataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobS3DataSource] inside the given [block]
         */
        public fun s3DataSource(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobS3DataSource.Builder.() -> kotlin.Unit) {
            this.s3DataSource = aws.sdk.kotlin.services.sagemaker.model.LabelingJobS3DataSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobSnsDataSource] inside the given [block]
         */
        public fun snsDataSource(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobSnsDataSource.Builder.() -> kotlin.Unit) {
            this.snsDataSource = aws.sdk.kotlin.services.sagemaker.model.LabelingJobSnsDataSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
