// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines how to perform inference generation after a training job is run.
 */
public class InferenceSpecification private constructor(builder: Builder) {
    /**
     * The Amazon ECR registry path of the Docker image that contains the inference code.
     */
    public val containers: List<ModelPackageContainerDefinition>? = builder.containers
    /**
     * The supported MIME types for the input data.
     */
    public val supportedContentTypes: List<String>? = builder.supportedContentTypes
    /**
     * A list of the instance types that are used to generate inferences in real-time.
     *
     * This parameter is required for unversioned models, and optional for versioned models.
     */
    public val supportedRealtimeInferenceInstanceTypes: List<ProductionVariantInstanceType>? = builder.supportedRealtimeInferenceInstanceTypes
    /**
     * The supported MIME types for the output data.
     */
    public val supportedResponseMimeTypes: List<String>? = builder.supportedResponseMimeTypes
    /**
     * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
     *
     * This parameter is required for unversioned models, and optional for versioned models.
     */
    public val supportedTransformInstanceTypes: List<TransformInstanceType>? = builder.supportedTransformInstanceTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceSpecification(")
        append("containers=$containers,")
        append("supportedContentTypes=$supportedContentTypes,")
        append("supportedRealtimeInferenceInstanceTypes=$supportedRealtimeInferenceInstanceTypes,")
        append("supportedResponseMimeTypes=$supportedResponseMimeTypes,")
        append("supportedTransformInstanceTypes=$supportedTransformInstanceTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containers?.hashCode() ?: 0
        result = 31 * result + (supportedContentTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedRealtimeInferenceInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedResponseMimeTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedTransformInstanceTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceSpecification

        if (containers != other.containers) return false
        if (supportedContentTypes != other.supportedContentTypes) return false
        if (supportedRealtimeInferenceInstanceTypes != other.supportedRealtimeInferenceInstanceTypes) return false
        if (supportedResponseMimeTypes != other.supportedResponseMimeTypes) return false
        if (supportedTransformInstanceTypes != other.supportedTransformInstanceTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon ECR registry path of the Docker image that contains the inference code.
         */
        public var containers: List<ModelPackageContainerDefinition>? = null
        /**
         * The supported MIME types for the input data.
         */
        public var supportedContentTypes: List<String>? = null
        /**
         * A list of the instance types that are used to generate inferences in real-time.
         *
         * This parameter is required for unversioned models, and optional for versioned models.
         */
        public var supportedRealtimeInferenceInstanceTypes: List<ProductionVariantInstanceType>? = null
        /**
         * The supported MIME types for the output data.
         */
        public var supportedResponseMimeTypes: List<String>? = null
        /**
         * A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.
         *
         * This parameter is required for unversioned models, and optional for versioned models.
         */
        public var supportedTransformInstanceTypes: List<TransformInstanceType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification) : this() {
            this.containers = x.containers
            this.supportedContentTypes = x.supportedContentTypes
            this.supportedRealtimeInferenceInstanceTypes = x.supportedRealtimeInferenceInstanceTypes
            this.supportedResponseMimeTypes = x.supportedResponseMimeTypes
            this.supportedTransformInstanceTypes = x.supportedTransformInstanceTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification = InferenceSpecification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
