// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the resources to deploy with this inference component, including the model, container, and compute resources.
 */
public class InferenceComponentSpecification private constructor(builder: Builder) {
    /**
     * The name of an existing inference component that is to contain the inference component that you're creating with your request.
     *
     * Specify this parameter only if your request is meant to create an adapter inference component. An adapter inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the inference output of a base foundation model, which is hosted by the base inference component. The adapter inference component uses the compute resources that you assigned to the base inference component.
     *
     * When you create an adapter inference component, use the `Container` parameter to specify the location of the adapter artifacts. In the parameter value, use the `ArtifactUrl` parameter of the `InferenceComponentContainerSpecification` data type.
     *
     * Before you can create an adapter inference component, you must have an existing inference component that contains the foundation model that you want to adapt.
     */
    public val baseInferenceComponentName: kotlin.String? = builder.baseInferenceComponentName
    /**
     * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference component.
     *
     * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference component is loaded by a base inference component, and it uses the compute resources of the base inference component.
     */
    public val computeResourceRequirements: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements? = builder.computeResourceRequirements
    /**
     * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
     */
    public val container: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification? = builder.container
    /**
     * The name of an existing SageMaker AI model object in your account that you want to deploy with the inference component.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Settings that take effect while the model container starts up.
     */
    public val startupParameters: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters? = builder.startupParameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceComponentSpecification(")
        append("baseInferenceComponentName=$baseInferenceComponentName,")
        append("computeResourceRequirements=$computeResourceRequirements,")
        append("container=$container,")
        append("modelName=$modelName,")
        append("startupParameters=$startupParameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseInferenceComponentName?.hashCode() ?: 0
        result = 31 * result + (computeResourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (startupParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceComponentSpecification

        if (baseInferenceComponentName != other.baseInferenceComponentName) return false
        if (computeResourceRequirements != other.computeResourceRequirements) return false
        if (container != other.container) return false
        if (modelName != other.modelName) return false
        if (startupParameters != other.startupParameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of an existing inference component that is to contain the inference component that you're creating with your request.
         *
         * Specify this parameter only if your request is meant to create an adapter inference component. An adapter inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the inference output of a base foundation model, which is hosted by the base inference component. The adapter inference component uses the compute resources that you assigned to the base inference component.
         *
         * When you create an adapter inference component, use the `Container` parameter to specify the location of the adapter artifacts. In the parameter value, use the `ArtifactUrl` parameter of the `InferenceComponentContainerSpecification` data type.
         *
         * Before you can create an adapter inference component, you must have an existing inference component that contains the foundation model that you want to adapt.
         */
        public var baseInferenceComponentName: kotlin.String? = null
        /**
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference component.
         *
         * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference component is loaded by a base inference component, and it uses the compute resources of the base inference component.
         */
        public var computeResourceRequirements: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements? = null
        /**
         * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
         */
        public var container: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification? = null
        /**
         * The name of an existing SageMaker AI model object in your account that you want to deploy with the inference component.
         */
        public var modelName: kotlin.String? = null
        /**
         * Settings that take effect while the model container starts up.
         */
        public var startupParameters: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification) : this() {
            this.baseInferenceComponentName = x.baseInferenceComponentName
            this.computeResourceRequirements = x.computeResourceRequirements
            this.container = x.container
            this.modelName = x.modelName
            this.startupParameters = x.startupParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.InferenceComponentSpecification = InferenceComponentSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements] inside the given [block]
         */
        public fun computeResourceRequirements(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements.Builder.() -> kotlin.Unit) {
            this.computeResourceRequirements = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentComputeResourceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification] inside the given [block]
         */
        public fun container(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification.Builder.() -> kotlin.Unit) {
            this.container = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentContainerSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters] inside the given [block]
         */
        public fun startupParameters(block: aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters.Builder.() -> kotlin.Unit) {
            this.startupParameters = aws.sdk.kotlin.services.sagemaker.model.InferenceComponentStartupParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
