// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeCompilationJobResponse private constructor(builder: Builder) {
    /**
     * The time when the model compilation job on a compilation job instance ended. For a successful or stopped job, this is when the job's model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker AI detected that the job failed.
     */
    public val compilationEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.compilationEndTime
    /**
     * The Amazon Resource Name (ARN) of the model compilation job.
     */
    public val compilationJobArn: kotlin.String? = builder.compilationJobArn
    /**
     * The name of the model compilation job.
     */
    public val compilationJobName: kotlin.String? = builder.compilationJobName
    /**
     * The status of the model compilation job.
     */
    public val compilationJobStatus: aws.sdk.kotlin.services.sagemaker.model.CompilationJobStatus? = builder.compilationJobStatus
    /**
     * The time when the model compilation job started the `CompilationJob` instances.
     *
     * You are billed for the time between this timestamp and the timestamp in the `CompilationEndTime` field. In Amazon CloudWatch Logs, the start time might be later than this time. That's because it takes time to download the compilation job, which depends on the size of the compilation job container.
     */
    public val compilationStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.compilationStartTime
    /**
     * The time that the model compilation job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information that SageMaker Neo automatically derived about the model.
     */
    public val derivedInformation: aws.sdk.kotlin.services.sagemaker.model.DerivedInformation? = builder.derivedInformation
    /**
     * If a model compilation job failed, the reason it failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The inference image to use when compiling a model. Specify an image only if the target device is a cloud instance.
     */
    public val inferenceImage: kotlin.String? = builder.inferenceImage
    /**
     * Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemaker.model.InputConfig? = builder.inputConfig
    /**
     * The time that the status of the model compilation job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.
     */
    public val modelArtifacts: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts? = builder.modelArtifacts
    /**
     * Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
     */
    public val modelDigests: aws.sdk.kotlin.services.sagemaker.model.ModelDigests? = builder.modelDigests
    /**
     * The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you initiated a compilation job.
     */
    public val modelPackageVersionArn: kotlin.String? = builder.modelPackageVersionArn
    /**
     * Information about the output location for the compiled model and the target device that the model runs on.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.OutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI assumes to perform the model compilation job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker AI ends the compilation job. Use this API to cap model training costs.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = builder.stoppingCondition
    /**
     * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see [Protect Compilation Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeCompilationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeCompilationJobResponse(")
        append("compilationEndTime=$compilationEndTime,")
        append("compilationJobArn=$compilationJobArn,")
        append("compilationJobName=$compilationJobName,")
        append("compilationJobStatus=$compilationJobStatus,")
        append("compilationStartTime=$compilationStartTime,")
        append("creationTime=$creationTime,")
        append("derivedInformation=$derivedInformation,")
        append("failureReason=$failureReason,")
        append("inferenceImage=$inferenceImage,")
        append("inputConfig=$inputConfig,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelArtifacts=$modelArtifacts,")
        append("modelDigests=$modelDigests,")
        append("modelPackageVersionArn=$modelPackageVersionArn,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compilationEndTime?.hashCode() ?: 0
        result = 31 * result + (compilationJobArn?.hashCode() ?: 0)
        result = 31 * result + (compilationJobName?.hashCode() ?: 0)
        result = 31 * result + (compilationJobStatus?.hashCode() ?: 0)
        result = 31 * result + (compilationStartTime?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (derivedInformation?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (inferenceImage?.hashCode() ?: 0)
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelArtifacts?.hashCode() ?: 0)
        result = 31 * result + (modelDigests?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersionArn?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeCompilationJobResponse

        if (compilationEndTime != other.compilationEndTime) return false
        if (compilationJobArn != other.compilationJobArn) return false
        if (compilationJobName != other.compilationJobName) return false
        if (compilationJobStatus != other.compilationJobStatus) return false
        if (compilationStartTime != other.compilationStartTime) return false
        if (creationTime != other.creationTime) return false
        if (derivedInformation != other.derivedInformation) return false
        if (failureReason != other.failureReason) return false
        if (inferenceImage != other.inferenceImage) return false
        if (inputConfig != other.inputConfig) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelArtifacts != other.modelArtifacts) return false
        if (modelDigests != other.modelDigests) return false
        if (modelPackageVersionArn != other.modelPackageVersionArn) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeCompilationJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time when the model compilation job on a compilation job instance ended. For a successful or stopped job, this is when the job's model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker AI detected that the job failed.
         */
        public var compilationEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model compilation job.
         */
        public var compilationJobArn: kotlin.String? = null
        /**
         * The name of the model compilation job.
         */
        public var compilationJobName: kotlin.String? = null
        /**
         * The status of the model compilation job.
         */
        public var compilationJobStatus: aws.sdk.kotlin.services.sagemaker.model.CompilationJobStatus? = null
        /**
         * The time when the model compilation job started the `CompilationJob` instances.
         *
         * You are billed for the time between this timestamp and the timestamp in the `CompilationEndTime` field. In Amazon CloudWatch Logs, the start time might be later than this time. That's because it takes time to download the compilation job, which depends on the size of the compilation job container.
         */
        public var compilationStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the model compilation job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information that SageMaker Neo automatically derived about the model.
         */
        public var derivedInformation: aws.sdk.kotlin.services.sagemaker.model.DerivedInformation? = null
        /**
         * If a model compilation job failed, the reason it failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The inference image to use when compiling a model. Specify an image only if the target device is a cloud instance.
         */
        public var inferenceImage: kotlin.String? = null
        /**
         * Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemaker.model.InputConfig? = null
        /**
         * The time that the status of the model compilation job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.
         */
        public var modelArtifacts: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts? = null
        /**
         * Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.
         */
        public var modelDigests: aws.sdk.kotlin.services.sagemaker.model.ModelDigests? = null
        /**
         * The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you initiated a compilation job.
         */
        public var modelPackageVersionArn: kotlin.String? = null
        /**
         * Information about the output location for the compiled model and the target device that the model runs on.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.OutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI assumes to perform the model compilation job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker AI ends the compilation job. Use this API to cap model training costs.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition? = null
        /**
         * A [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html) object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see [Protect Compilation Jobs by Using an Amazon Virtual Private Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeCompilationJobResponse) : this() {
            this.compilationEndTime = x.compilationEndTime
            this.compilationJobArn = x.compilationJobArn
            this.compilationJobName = x.compilationJobName
            this.compilationJobStatus = x.compilationJobStatus
            this.compilationStartTime = x.compilationStartTime
            this.creationTime = x.creationTime
            this.derivedInformation = x.derivedInformation
            this.failureReason = x.failureReason
            this.inferenceImage = x.inferenceImage
            this.inputConfig = x.inputConfig
            this.lastModifiedTime = x.lastModifiedTime
            this.modelArtifacts = x.modelArtifacts
            this.modelDigests = x.modelDigests
            this.modelPackageVersionArn = x.modelPackageVersionArn
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeCompilationJobResponse = DescribeCompilationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DerivedInformation] inside the given [block]
         */
        public fun derivedInformation(block: aws.sdk.kotlin.services.sagemaker.model.DerivedInformation.Builder.() -> kotlin.Unit) {
            this.derivedInformation = aws.sdk.kotlin.services.sagemaker.model.DerivedInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InputConfig] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemaker.model.InputConfig.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemaker.model.InputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts] inside the given [block]
         */
        public fun modelArtifacts(block: aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts.Builder.() -> kotlin.Unit) {
            this.modelArtifacts = aws.sdk.kotlin.services.sagemaker.model.ModelArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelDigests] inside the given [block]
         */
        public fun modelDigests(block: aws.sdk.kotlin.services.sagemaker.model.ModelDigests.Builder.() -> kotlin.Unit) {
            this.modelDigests = aws.sdk.kotlin.services.sagemaker.model.ModelDigests.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.OutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.StoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.StoppingCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
