// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateModelCardRequest private constructor(builder: Builder) {
    /**
     * The content of the model card. Content must be in [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema) and provided as a string.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The unique name of the model card.
     */
    public val modelCardName: kotlin.String? = builder.modelCardName
    /**
     * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
     * + `Draft`: The model card is a work in progress.
     * + `PendingReview`: The model card is pending review.
     * + `Approved`: The model card is approved.
     * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
     */
    public val modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = builder.modelCardStatus
    /**
     * An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated workloads with highly sensitive data.
     */
    public val securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = builder.securityConfig
    /**
     * Key-value pairs used to manage metadata for model cards.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelCardRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelCardRequest(")
        append("content=*** Sensitive Data Redacted ***,")
        append("modelCardName=$modelCardName,")
        append("modelCardStatus=$modelCardStatus,")
        append("securityConfig=$securityConfig,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.hashCode() ?: 0
        result = 31 * result + (modelCardName?.hashCode() ?: 0)
        result = 31 * result + (modelCardStatus?.hashCode() ?: 0)
        result = 31 * result + (securityConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelCardRequest

        if (content != other.content) return false
        if (modelCardName != other.modelCardName) return false
        if (modelCardStatus != other.modelCardStatus) return false
        if (securityConfig != other.securityConfig) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelCardRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The content of the model card. Content must be in [model card JSON schema](https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema) and provided as a string.
         */
        public var content: kotlin.String? = null
        /**
         * The unique name of the model card.
         */
        public var modelCardName: kotlin.String? = null
        /**
         * The approval status of the model card within your organization. Different organizations might have different criteria for model card review and approval.
         * + `Draft`: The model card is a work in progress.
         * + `PendingReview`: The model card is pending review.
         * + `Approved`: The model card is approved.
         * + `Archived`: The model card is archived. No more updates should be made to the model card, but it can still be exported.
         */
        public var modelCardStatus: aws.sdk.kotlin.services.sagemaker.model.ModelCardStatus? = null
        /**
         * An optional Key Management Service key to encrypt, decrypt, and re-encrypt model card content for regulated workloads with highly sensitive data.
         */
        public var securityConfig: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig? = null
        /**
         * Key-value pairs used to manage metadata for model cards.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelCardRequest) : this() {
            this.content = x.content
            this.modelCardName = x.modelCardName
            this.modelCardStatus = x.modelCardStatus
            this.securityConfig = x.securityConfig
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelCardRequest = CreateModelCardRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig] inside the given [block]
         */
        public fun securityConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.Builder.() -> kotlin.Unit) {
            this.securityConfig = aws.sdk.kotlin.services.sagemaker.model.ModelCardSecurityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
