// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateImageVersionRequest private constructor(builder: Builder) {
    /**
     * A list of aliases created with the image version.
     */
    public val aliases: List<String>? = builder.aliases
    /**
     * The registry path of the container image to use as the starting point for this version. The path is an Amazon ECR URI in the following format:
     *
     * `<acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]>`
     */
    public val baseImage: kotlin.String? = builder.baseImage
    /**
     * A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Indicates Horovod compatibility.
     */
    public val horovod: kotlin.Boolean? = builder.horovod
    /**
     * The `ImageName` of the `Image` to create a version of.
     */
    public val imageName: kotlin.String? = builder.imageName
    /**
     * Indicates SageMaker AI job type compatibility.
     * + `TRAINING`: The image version is compatible with SageMaker AI training jobs.
     * + `INFERENCE`: The image version is compatible with SageMaker AI inference jobs.
     * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker AI notebook kernels.
     */
    public val jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = builder.jobType
    /**
     * The machine learning framework vended in the image version.
     */
    public val mlFramework: kotlin.String? = builder.mlFramework
    /**
     * Indicates CPU or GPU compatibility.
     * + `CPU`: The image version is compatible with CPU.
     * + `GPU`: The image version is compatible with GPU.
     */
    public val processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = builder.processor
    /**
     * The supported programming language and its version.
     */
    public val programmingLang: kotlin.String? = builder.programmingLang
    /**
     * The maintainer description of the image version.
     */
    public val releaseNotes: kotlin.String? = builder.releaseNotes
    /**
     * The stability of the image version, specified by the maintainer.
     * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
     * + `STABLE`: The image version is stable.
     * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
     * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
     */
    public val vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = builder.vendorGuidance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateImageVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateImageVersionRequest(")
        append("aliases=$aliases,")
        append("baseImage=$baseImage,")
        append("clientToken=$clientToken,")
        append("horovod=$horovod,")
        append("imageName=$imageName,")
        append("jobType=$jobType,")
        append("mlFramework=$mlFramework,")
        append("processor=$processor,")
        append("programmingLang=$programmingLang,")
        append("releaseNotes=$releaseNotes,")
        append("vendorGuidance=$vendorGuidance")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (baseImage?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (horovod?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (mlFramework?.hashCode() ?: 0)
        result = 31 * result + (processor?.hashCode() ?: 0)
        result = 31 * result + (programmingLang?.hashCode() ?: 0)
        result = 31 * result + (releaseNotes?.hashCode() ?: 0)
        result = 31 * result + (vendorGuidance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateImageVersionRequest

        if (aliases != other.aliases) return false
        if (baseImage != other.baseImage) return false
        if (clientToken != other.clientToken) return false
        if (horovod != other.horovod) return false
        if (imageName != other.imageName) return false
        if (jobType != other.jobType) return false
        if (mlFramework != other.mlFramework) return false
        if (processor != other.processor) return false
        if (programmingLang != other.programmingLang) return false
        if (releaseNotes != other.releaseNotes) return false
        if (vendorGuidance != other.vendorGuidance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateImageVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of aliases created with the image version.
         */
        public var aliases: List<String>? = null
        /**
         * The registry path of the container image to use as the starting point for this version. The path is an Amazon ECR URI in the following format:
         *
         * `<acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]>`
         */
        public var baseImage: kotlin.String? = null
        /**
         * A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Indicates Horovod compatibility.
         */
        public var horovod: kotlin.Boolean? = null
        /**
         * The `ImageName` of the `Image` to create a version of.
         */
        public var imageName: kotlin.String? = null
        /**
         * Indicates SageMaker AI job type compatibility.
         * + `TRAINING`: The image version is compatible with SageMaker AI training jobs.
         * + `INFERENCE`: The image version is compatible with SageMaker AI inference jobs.
         * + `NOTEBOOK_KERNEL`: The image version is compatible with SageMaker AI notebook kernels.
         */
        public var jobType: aws.sdk.kotlin.services.sagemaker.model.JobType? = null
        /**
         * The machine learning framework vended in the image version.
         */
        public var mlFramework: kotlin.String? = null
        /**
         * Indicates CPU or GPU compatibility.
         * + `CPU`: The image version is compatible with CPU.
         * + `GPU`: The image version is compatible with GPU.
         */
        public var processor: aws.sdk.kotlin.services.sagemaker.model.Processor? = null
        /**
         * The supported programming language and its version.
         */
        public var programmingLang: kotlin.String? = null
        /**
         * The maintainer description of the image version.
         */
        public var releaseNotes: kotlin.String? = null
        /**
         * The stability of the image version, specified by the maintainer.
         * + `NOT_PROVIDED`: The maintainers did not provide a status for image version stability.
         * + `STABLE`: The image version is stable.
         * + `TO_BE_ARCHIVED`: The image version is set to be archived. Custom image versions that are set to be archived are automatically archived after three months.
         * + `ARCHIVED`: The image version is archived. Archived image versions are not searchable and are no longer actively supported.
         */
        public var vendorGuidance: aws.sdk.kotlin.services.sagemaker.model.VendorGuidance? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateImageVersionRequest) : this() {
            this.aliases = x.aliases
            this.baseImage = x.baseImage
            this.clientToken = x.clientToken
            this.horovod = x.horovod
            this.imageName = x.imageName
            this.jobType = x.jobType
            this.mlFramework = x.mlFramework
            this.processor = x.processor
            this.programmingLang = x.programmingLang
            this.releaseNotes = x.releaseNotes
            this.vendorGuidance = x.vendorGuidance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateImageVersionRequest = CreateImageVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
