// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFlowDefinitionRequest private constructor(builder: Builder) {
    /**
     * The name of your flow definition.
     */
    public val flowDefinitionName: kotlin.String? = builder.flowDefinitionName
    /**
     * An object containing information about the events that trigger a human workflow.
     */
    public val humanLoopActivationConfig: aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig? = builder.humanLoopActivationConfig
    /**
     * An object containing information about the tasks the human reviewers will perform.
     */
    public val humanLoopConfig: aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig? = builder.humanLoopConfig
    /**
     * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.
     */
    public val humanLoopRequestSource: aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource? = builder.humanLoopRequestSource
    /**
     * An object containing information about where the human review results will be uploaded.
     */
    public val outputConfig: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, `arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298`.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateFlowDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowDefinitionRequest(")
        append("flowDefinitionName=$flowDefinitionName,")
        append("humanLoopActivationConfig=$humanLoopActivationConfig,")
        append("humanLoopConfig=$humanLoopConfig,")
        append("humanLoopRequestSource=$humanLoopRequestSource,")
        append("outputConfig=$outputConfig,")
        append("roleArn=$roleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = flowDefinitionName?.hashCode() ?: 0
        result = 31 * result + (humanLoopActivationConfig?.hashCode() ?: 0)
        result = 31 * result + (humanLoopConfig?.hashCode() ?: 0)
        result = 31 * result + (humanLoopRequestSource?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFlowDefinitionRequest

        if (flowDefinitionName != other.flowDefinitionName) return false
        if (humanLoopActivationConfig != other.humanLoopActivationConfig) return false
        if (humanLoopConfig != other.humanLoopConfig) return false
        if (humanLoopRequestSource != other.humanLoopRequestSource) return false
        if (outputConfig != other.outputConfig) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateFlowDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of your flow definition.
         */
        public var flowDefinitionName: kotlin.String? = null
        /**
         * An object containing information about the events that trigger a human workflow.
         */
        public var humanLoopActivationConfig: aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig? = null
        /**
         * An object containing information about the tasks the human reviewers will perform.
         */
        public var humanLoopConfig: aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig? = null
        /**
         * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.
         */
        public var humanLoopRequestSource: aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource? = null
        /**
         * An object containing information about where the human review results will be uploaded.
         */
        public var outputConfig: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, `arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298`.
         */
        public var roleArn: kotlin.String? = null
        /**
         * An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateFlowDefinitionRequest) : this() {
            this.flowDefinitionName = x.flowDefinitionName
            this.humanLoopActivationConfig = x.humanLoopActivationConfig
            this.humanLoopConfig = x.humanLoopConfig
            this.humanLoopRequestSource = x.humanLoopRequestSource
            this.outputConfig = x.outputConfig
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateFlowDefinitionRequest = CreateFlowDefinitionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig] inside the given [block]
         */
        public fun humanLoopActivationConfig(block: aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig.Builder.() -> kotlin.Unit) {
            this.humanLoopActivationConfig = aws.sdk.kotlin.services.sagemaker.model.HumanLoopActivationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig] inside the given [block]
         */
        public fun humanLoopConfig(block: aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig.Builder.() -> kotlin.Unit) {
            this.humanLoopConfig = aws.sdk.kotlin.services.sagemaker.model.HumanLoopConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource] inside the given [block]
         */
        public fun humanLoopRequestSource(block: aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource.Builder.() -> kotlin.Unit) {
            this.humanLoopRequestSource = aws.sdk.kotlin.services.sagemaker.model.HumanLoopRequestSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
