// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFeatureGroupRequest private constructor(builder: Builder) {
    /**
     * A free-form description of a `FeatureGroup`.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the feature that stores the `EventTime` of a `Record` in a `FeatureGroup`.
     *
     * An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` must have a corresponding `EventTime`.
     *
     * An `EventTime` can be a `String` or `Fractional`.
     * + `Fractional`: `EventTime` feature values must be a Unix timestamp in seconds.
     * + `String`: `EventTime` feature values must be an ISO-8601 string in the format. The following formats are supported `yyyy-MM-dd'T'HH:mm:ssZ` and `yyyy-MM-dd'T'HH:mm:ss.SSSZ` where `yyyy`, `MM`, and `dd` represent the year, month, and day respectively and `HH`, `mm`, `ss`, and if applicable, `SSS` represent the hour, month, second and milliseconds respsectively. `'T'` and `Z` are constants.
     */
    public val eventTimeFeatureName: kotlin.String? = builder.eventTimeFeatureName
    /**
     * A list of `Feature` names and types. `Name` and `Type` is compulsory per `Feature`.
     *
     * Valid feature `FeatureType`s are `Integral`, `Fractional` and `String`.
     *
     * `FeatureName`s cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`
     *
     * You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
     */
    public val featureDefinitions: List<FeatureDefinition>? = builder.featureDefinitions
    /**
     * The name of the `FeatureGroup`. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
     *
     * The name:
     * + Must start with an alphanumeric character.
     * + Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
     */
    public val featureGroupName: kotlin.String? = builder.featureGroupName
    /**
     * Use this to configure an `OfflineFeatureStore`. This parameter allows you to specify:
     * + The Amazon Simple Storage Service (Amazon S3) location of an `OfflineStore`.
     * + A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
     * + An KMS encryption key to encrypt the Amazon S3 location used for `OfflineStore`. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your [bucket-level key](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html) for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
     * + Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://iceberg.apache.org/).
     *
     * To learn more about this parameter, see [OfflineStoreConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html).
     */
    public val offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = builder.offlineStoreConfig
    /**
     * You can turn the `OnlineStore` on or off by specifying `True` for the `EnableOnlineStore` flag in `OnlineStoreConfig`.
     *
     * You can also include an Amazon Web Services KMS key ID (`KMSKeyId`) for at-rest encryption of the `OnlineStore`.
     *
     * The default value is `False`.
     */
    public val onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = builder.onlineStoreConfig
    /**
     * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureStore`. Only the latest record per identifier value will be stored in the `OnlineStore`. `RecordIdentifierFeatureName` must be one of feature definitions' names.
     *
     * You use the `RecordIdentifierFeatureName` to access data in a `FeatureStore`.
     *
     * This name:
     * + Must start with an alphanumeric character.
     * + Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
     */
    public val recordIdentifierFeatureName: kotlin.String? = builder.recordIdentifierFeatureName
    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Tags used to identify `Features` in each `FeatureGroup`.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED`. With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
     *
     * Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the `Standard`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
     */
    public val throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfig? = builder.throughputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateFeatureGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFeatureGroupRequest(")
        append("description=$description,")
        append("eventTimeFeatureName=$eventTimeFeatureName,")
        append("featureDefinitions=$featureDefinitions,")
        append("featureGroupName=$featureGroupName,")
        append("offlineStoreConfig=$offlineStoreConfig,")
        append("onlineStoreConfig=$onlineStoreConfig,")
        append("recordIdentifierFeatureName=$recordIdentifierFeatureName,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("throughputConfig=$throughputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (eventTimeFeatureName?.hashCode() ?: 0)
        result = 31 * result + (featureDefinitions?.hashCode() ?: 0)
        result = 31 * result + (featureGroupName?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (recordIdentifierFeatureName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFeatureGroupRequest

        if (description != other.description) return false
        if (eventTimeFeatureName != other.eventTimeFeatureName) return false
        if (featureDefinitions != other.featureDefinitions) return false
        if (featureGroupName != other.featureGroupName) return false
        if (offlineStoreConfig != other.offlineStoreConfig) return false
        if (onlineStoreConfig != other.onlineStoreConfig) return false
        if (recordIdentifierFeatureName != other.recordIdentifierFeatureName) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (throughputConfig != other.throughputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateFeatureGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A free-form description of a `FeatureGroup`.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the feature that stores the `EventTime` of a `Record` in a `FeatureGroup`.
         *
         * An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` must have a corresponding `EventTime`.
         *
         * An `EventTime` can be a `String` or `Fractional`.
         * + `Fractional`: `EventTime` feature values must be a Unix timestamp in seconds.
         * + `String`: `EventTime` feature values must be an ISO-8601 string in the format. The following formats are supported `yyyy-MM-dd'T'HH:mm:ssZ` and `yyyy-MM-dd'T'HH:mm:ss.SSSZ` where `yyyy`, `MM`, and `dd` represent the year, month, and day respectively and `HH`, `mm`, `ss`, and if applicable, `SSS` represent the hour, month, second and milliseconds respsectively. `'T'` and `Z` are constants.
         */
        public var eventTimeFeatureName: kotlin.String? = null
        /**
         * A list of `Feature` names and types. `Name` and `Type` is compulsory per `Feature`.
         *
         * Valid feature `FeatureType`s are `Integral`, `Fractional` and `String`.
         *
         * `FeatureName`s cannot be any of the following: `is_deleted`, `write_time`, `api_invocation_time`
         *
         * You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
         */
        public var featureDefinitions: List<FeatureDefinition>? = null
        /**
         * The name of the `FeatureGroup`. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.
         *
         * The name:
         * + Must start with an alphanumeric character.
         * + Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.
         */
        public var featureGroupName: kotlin.String? = null
        /**
         * Use this to configure an `OfflineFeatureStore`. This parameter allows you to specify:
         * + The Amazon Simple Storage Service (Amazon S3) location of an `OfflineStore`.
         * + A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog.
         * + An KMS encryption key to encrypt the Amazon S3 location used for `OfflineStore`. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your [bucket-level key](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html) for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.
         * + Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg](https://iceberg.apache.org/).
         *
         * To learn more about this parameter, see [OfflineStoreConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OfflineStoreConfig.html).
         */
        public var offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = null
        /**
         * You can turn the `OnlineStore` on or off by specifying `True` for the `EnableOnlineStore` flag in `OnlineStoreConfig`.
         *
         * You can also include an Amazon Web Services KMS key ID (`KMSKeyId`) for at-rest encryption of the `OnlineStore`.
         *
         * The default value is `False`.
         */
        public var onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = null
        /**
         * The name of the `Feature` whose value uniquely identifies a `Record` defined in the `FeatureStore`. Only the latest record per identifier value will be stored in the `OnlineStore`. `RecordIdentifierFeatureName` must be one of feature definitions' names.
         *
         * You use the `RecordIdentifierFeatureName` to access data in a `FeatureStore`.
         *
         * This name:
         * + Must start with an alphanumeric character.
         * + Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed.
         */
        public var recordIdentifierFeatureName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Tags used to identify `Features` in each `FeatureGroup`.
         */
        public var tags: List<Tag>? = null
        /**
         * Used to set feature group throughput configuration. There are two modes: `ON_DEMAND` and `PROVISIONED`. With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         *
         * Note: `PROVISIONED` throughput mode is supported only for feature groups that are offline-only, or use the `Standard`[](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType) tier online store.
         */
        public var throughputConfig: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateFeatureGroupRequest) : this() {
            this.description = x.description
            this.eventTimeFeatureName = x.eventTimeFeatureName
            this.featureDefinitions = x.featureDefinitions
            this.featureGroupName = x.featureGroupName
            this.offlineStoreConfig = x.offlineStoreConfig
            this.onlineStoreConfig = x.onlineStoreConfig
            this.recordIdentifierFeatureName = x.recordIdentifierFeatureName
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.throughputConfig = x.throughputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateFeatureGroupRequest = CreateFeatureGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig] inside the given [block]
         */
        public fun offlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.Builder.() -> kotlin.Unit) {
            this.offlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig] inside the given [block]
         */
        public fun onlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.Builder.() -> kotlin.Unit) {
            this.onlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ThroughputConfig] inside the given [block]
         */
        public fun throughputConfig(block: aws.sdk.kotlin.services.sagemaker.model.ThroughputConfig.Builder.() -> kotlin.Unit) {
            this.throughputConfig = aws.sdk.kotlin.services.sagemaker.model.ThroughputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
