// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppRequest private constructor(builder: Builder) {
    /**
     * The name of the app.
     */
    public val appName: kotlin.String? = builder.appName
    /**
     * The type of app.
     */
    public val appType: aws.sdk.kotlin.services.sagemaker.model.AppType? = builder.appType
    /**
     * The domain ID.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The instance type and the Amazon Resource Name (ARN) of the SageMaker AI image created on the instance.
     *
     * The value of `InstanceType` passed as part of the `ResourceSpec` in the `CreateApp` call overrides the value passed as part of the `ResourceSpec` configured for the user profile or the domain. If `InstanceType` is not specified in any of those three `ResourceSpec` values for a `KernelGateway` app, the `CreateApp` call fails with a request validation error.
     */
    public val resourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = builder.resourceSpec
    /**
     * The name of the space. If this value is not set, then `UserProfileName` must be set.
     */
    public val spaceName: kotlin.String? = builder.spaceName
    /**
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user profile name. If this value is not set, then `SpaceName` must be set.
     */
    public val userProfileName: kotlin.String? = builder.userProfileName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppRequest(")
        append("appName=$appName,")
        append("appType=$appType,")
        append("domainId=$domainId,")
        append("resourceSpec=$resourceSpec,")
        append("spaceName=$spaceName,")
        append("tags=$tags,")
        append("userProfileName=$userProfileName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appName?.hashCode() ?: 0
        result = 31 * result + (appType?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (resourceSpec?.hashCode() ?: 0)
        result = 31 * result + (spaceName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userProfileName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppRequest

        if (appName != other.appName) return false
        if (appType != other.appType) return false
        if (domainId != other.domainId) return false
        if (resourceSpec != other.resourceSpec) return false
        if (spaceName != other.spaceName) return false
        if (tags != other.tags) return false
        if (userProfileName != other.userProfileName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateAppRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the app.
         */
        public var appName: kotlin.String? = null
        /**
         * The type of app.
         */
        public var appType: aws.sdk.kotlin.services.sagemaker.model.AppType? = null
        /**
         * The domain ID.
         */
        public var domainId: kotlin.String? = null
        /**
         * The instance type and the Amazon Resource Name (ARN) of the SageMaker AI image created on the instance.
         *
         * The value of `InstanceType` passed as part of the `ResourceSpec` in the `CreateApp` call overrides the value passed as part of the `ResourceSpec` configured for the user profile or the domain. If `InstanceType` is not specified in any of those three `ResourceSpec` values for a `KernelGateway` app, the `CreateApp` call fails with a request validation error.
         */
        public var resourceSpec: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec? = null
        /**
         * The name of the space. If this value is not set, then `UserProfileName` must be set.
         */
        public var spaceName: kotlin.String? = null
        /**
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The user profile name. If this value is not set, then `SpaceName` must be set.
         */
        public var userProfileName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateAppRequest) : this() {
            this.appName = x.appName
            this.appType = x.appType
            this.domainId = x.domainId
            this.resourceSpec = x.resourceSpec
            this.spaceName = x.spaceName
            this.tags = x.tags
            this.userProfileName = x.userProfileName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateAppRequest = CreateAppRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceSpec] inside the given [block]
         */
        public fun resourceSpec(block: aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.Builder.() -> kotlin.Unit) {
            this.resourceSpec = aws.sdk.kotlin.services.sagemaker.model.ResourceSpec.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
