// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration of the compute allocation definition for an entity. This includes the resource sharing option and the setting to preempt low priority tasks.
 */
public class ComputeQuotaConfig private constructor(builder: Builder) {
    /**
     * Allocate compute resources by instance types.
     */
    public val computeQuotaResources: List<ComputeQuotaResourceConfig>? = builder.computeQuotaResources
    /**
     * Allows workloads from within an entity to preempt same-team workloads. When set to `LowerPriority`, the entity's lower priority tasks are preempted by their own higher priority tasks.
     *
     * Default is `LowerPriority`.
     */
    public val preemptTeamTasks: aws.sdk.kotlin.services.sagemaker.model.PreemptTeamTasks? = builder.preemptTeamTasks
    /**
     * Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other entities within the cluster.
     */
    public val resourceSharingConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig? = builder.resourceSharingConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeQuotaConfig(")
        append("computeQuotaResources=$computeQuotaResources,")
        append("preemptTeamTasks=$preemptTeamTasks,")
        append("resourceSharingConfig=$resourceSharingConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeQuotaResources?.hashCode() ?: 0
        result = 31 * result + (preemptTeamTasks?.hashCode() ?: 0)
        result = 31 * result + (resourceSharingConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeQuotaConfig

        if (computeQuotaResources != other.computeQuotaResources) return false
        if (preemptTeamTasks != other.preemptTeamTasks) return false
        if (resourceSharingConfig != other.resourceSharingConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Allocate compute resources by instance types.
         */
        public var computeQuotaResources: List<ComputeQuotaResourceConfig>? = null
        /**
         * Allows workloads from within an entity to preempt same-team workloads. When set to `LowerPriority`, the entity's lower priority tasks are preempted by their own higher priority tasks.
         *
         * Default is `LowerPriority`.
         */
        public var preemptTeamTasks: aws.sdk.kotlin.services.sagemaker.model.PreemptTeamTasks? = null
        /**
         * Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other entities within the cluster.
         */
        public var resourceSharingConfig: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaConfig) : this() {
            this.computeQuotaResources = x.computeQuotaResources
            this.preemptTeamTasks = x.preemptTeamTasks
            this.resourceSharingConfig = x.resourceSharingConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ComputeQuotaConfig = ComputeQuotaConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig] inside the given [block]
         */
        public fun resourceSharingConfig(block: aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig.Builder.() -> kotlin.Unit) {
            this.resourceSharingConfig = aws.sdk.kotlin.services.sagemaker.model.ResourceSharingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
