// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Lists a summary of the properties of an instance (also called a *node* interchangeably) of a SageMaker HyperPod cluster.
 */
public class ClusterNodeSummary private constructor(builder: Builder) {
    /**
     * The name of the instance group in which the instance is.
     */
    public val instanceGroupName: kotlin.String? = builder.instanceGroupName
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The status of the instance.
     */
    public val instanceStatus: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails? = builder.instanceStatus
    /**
     * The type of the instance.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = builder.instanceType
    /**
     * The time when the instance is launched.
     */
    public val launchTime: aws.smithy.kotlin.runtime.time.Instant? = builder.launchTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterNodeSummary(")
        append("instanceGroupName=$instanceGroupName,")
        append("instanceId=$instanceId,")
        append("instanceStatus=$instanceStatus,")
        append("instanceType=$instanceType,")
        append("launchTime=$launchTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceGroupName?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceStatus?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterNodeSummary

        if (instanceGroupName != other.instanceGroupName) return false
        if (instanceId != other.instanceId) return false
        if (instanceStatus != other.instanceStatus) return false
        if (instanceType != other.instanceType) return false
        if (launchTime != other.launchTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the instance group in which the instance is.
         */
        public var instanceGroupName: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The status of the instance.
         */
        public var instanceStatus: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails? = null
        /**
         * The type of the instance.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = null
        /**
         * The time when the instance is launched.
         */
        public var launchTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClusterNodeSummary) : this() {
            this.instanceGroupName = x.instanceGroupName
            this.instanceId = x.instanceId
            this.instanceStatus = x.instanceStatus
            this.instanceType = x.instanceType
            this.launchTime = x.launchTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeSummary = ClusterNodeSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails] inside the given [block]
         */
        public fun instanceStatus(block: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails.Builder.() -> kotlin.Unit) {
            this.instanceStatus = aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
