// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of an instance (also called a *node* interchangeably) in a SageMaker HyperPod cluster.
 */
public class ClusterNodeDetails private constructor(builder: Builder) {
    /**
     * The instance group name in which the instance is.
     */
    public val instanceGroupName: kotlin.String? = builder.instanceGroupName
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The status of the instance.
     */
    public val instanceStatus: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails? = builder.instanceStatus
    /**
     * The configurations of additional storage specified to the instance group where the instance (node) is launched.
     */
    public val instanceStorageConfigs: List<ClusterInstanceStorageConfig>? = builder.instanceStorageConfigs
    /**
     * The type of the instance.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = builder.instanceType
    /**
     * The time when the instance is launched.
     */
    public val launchTime: aws.smithy.kotlin.runtime.time.Instant? = builder.launchTime
    /**
     * The LifeCycle configuration applied to the instance.
     */
    public val lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = builder.lifeCycleConfig
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
     */
    public val overrideVpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = builder.overrideVpcConfig
    /**
     * The placement details of the SageMaker HyperPod cluster node.
     */
    public val placement: aws.sdk.kotlin.services.sagemaker.model.ClusterInstancePlacement? = builder.placement
    /**
     * The private DNS hostname of the SageMaker HyperPod cluster node.
     */
    public val privateDnsHostname: kotlin.String? = builder.privateDnsHostname
    /**
     * The private primary IP address of the SageMaker HyperPod cluster node.
     */
    public val privatePrimaryIp: kotlin.String? = builder.privatePrimaryIp
    /**
     * The number of threads per CPU core you specified under `CreateCluster`.
     */
    public val threadsPerCore: kotlin.Int? = builder.threadsPerCore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterNodeDetails(")
        append("instanceGroupName=$instanceGroupName,")
        append("instanceId=$instanceId,")
        append("instanceStatus=$instanceStatus,")
        append("instanceStorageConfigs=$instanceStorageConfigs,")
        append("instanceType=$instanceType,")
        append("launchTime=$launchTime,")
        append("lifeCycleConfig=$lifeCycleConfig,")
        append("overrideVpcConfig=$overrideVpcConfig,")
        append("placement=$placement,")
        append("privateDnsHostname=$privateDnsHostname,")
        append("privatePrimaryIp=$privatePrimaryIp,")
        append("threadsPerCore=$threadsPerCore")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceGroupName?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceStatus?.hashCode() ?: 0)
        result = 31 * result + (instanceStorageConfigs?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchTime?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleConfig?.hashCode() ?: 0)
        result = 31 * result + (overrideVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (privateDnsHostname?.hashCode() ?: 0)
        result = 31 * result + (privatePrimaryIp?.hashCode() ?: 0)
        result = 31 * result + (threadsPerCore ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterNodeDetails

        if (instanceGroupName != other.instanceGroupName) return false
        if (instanceId != other.instanceId) return false
        if (instanceStatus != other.instanceStatus) return false
        if (instanceStorageConfigs != other.instanceStorageConfigs) return false
        if (instanceType != other.instanceType) return false
        if (launchTime != other.launchTime) return false
        if (lifeCycleConfig != other.lifeCycleConfig) return false
        if (overrideVpcConfig != other.overrideVpcConfig) return false
        if (placement != other.placement) return false
        if (privateDnsHostname != other.privateDnsHostname) return false
        if (privatePrimaryIp != other.privatePrimaryIp) return false
        if (threadsPerCore != other.threadsPerCore) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instance group name in which the instance is.
         */
        public var instanceGroupName: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The status of the instance.
         */
        public var instanceStatus: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails? = null
        /**
         * The configurations of additional storage specified to the instance group where the instance (node) is launched.
         */
        public var instanceStorageConfigs: List<ClusterInstanceStorageConfig>? = null
        /**
         * The type of the instance.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceType? = null
        /**
         * The time when the instance is launched.
         */
        public var launchTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The LifeCycle configuration applied to the instance.
         */
        public var lifeCycleConfig: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig? = null
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. You can control access to and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html).
         */
        public var overrideVpcConfig: aws.sdk.kotlin.services.sagemaker.model.VpcConfig? = null
        /**
         * The placement details of the SageMaker HyperPod cluster node.
         */
        public var placement: aws.sdk.kotlin.services.sagemaker.model.ClusterInstancePlacement? = null
        /**
         * The private DNS hostname of the SageMaker HyperPod cluster node.
         */
        public var privateDnsHostname: kotlin.String? = null
        /**
         * The private primary IP address of the SageMaker HyperPod cluster node.
         */
        public var privatePrimaryIp: kotlin.String? = null
        /**
         * The number of threads per CPU core you specified under `CreateCluster`.
         */
        public var threadsPerCore: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ClusterNodeDetails) : this() {
            this.instanceGroupName = x.instanceGroupName
            this.instanceId = x.instanceId
            this.instanceStatus = x.instanceStatus
            this.instanceStorageConfigs = x.instanceStorageConfigs
            this.instanceType = x.instanceType
            this.launchTime = x.launchTime
            this.lifeCycleConfig = x.lifeCycleConfig
            this.overrideVpcConfig = x.overrideVpcConfig
            this.placement = x.placement
            this.privateDnsHostname = x.privateDnsHostname
            this.privatePrimaryIp = x.privatePrimaryIp
            this.threadsPerCore = x.threadsPerCore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ClusterNodeDetails = ClusterNodeDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails] inside the given [block]
         */
        public fun instanceStatus(block: aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails.Builder.() -> kotlin.Unit) {
            this.instanceStatus = aws.sdk.kotlin.services.sagemaker.model.ClusterInstanceStatusDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig] inside the given [block]
         */
        public fun lifeCycleConfig(block: aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.Builder.() -> kotlin.Unit) {
            this.lifeCycleConfig = aws.sdk.kotlin.services.sagemaker.model.ClusterLifeCycleConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.VpcConfig] inside the given [block]
         */
        public fun overrideVpcConfig(block: aws.sdk.kotlin.services.sagemaker.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.overrideVpcConfig = aws.sdk.kotlin.services.sagemaker.model.VpcConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ClusterInstancePlacement] inside the given [block]
         */
        public fun placement(block: aws.sdk.kotlin.services.sagemaker.model.ClusterInstancePlacement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.sagemaker.model.ClusterInstancePlacement.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
