// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * How long a job is allowed to run, or how many candidates a job is allowed to generate.
 */
public class AutoMlJobCompletionCriteria private constructor(builder: Builder) {
    /**
     * The maximum runtime, in seconds, an AutoML job has to complete.
     *
     * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, are not completed.
     */
    public val maxAutoMlJobRuntimeInSeconds: kotlin.Int? = builder.maxAutoMlJobRuntimeInSeconds
    /**
     * The maximum number of times a training job is allowed to run.
     *
     * For text and image classification, time-series forecasting, as well as text generation (LLMs fine-tuning) problem types, the supported value is 1. For tabular problem types, the maximum value is 750.
     */
    public val maxCandidates: kotlin.Int? = builder.maxCandidates
    /**
     * The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to run as part of a hyperparameter tuning job. For more information, see the [StoppingCondition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html) used by the [CreateHyperParameterTuningJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html) action.
     *
     * For job V2s (jobs created by calling `CreateAutoMLJobV2`), this field controls the runtime of the job candidate.
     *
     * For [TextGenerationJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TextClassificationJobConfig.html) problem types, the maximum time defaults to 72 hours (259200 seconds).
     */
    public val maxRuntimePerTrainingJobInSeconds: kotlin.Int? = builder.maxRuntimePerTrainingJobInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlJobCompletionCriteria(")
        append("maxAutoMlJobRuntimeInSeconds=$maxAutoMlJobRuntimeInSeconds,")
        append("maxCandidates=$maxCandidates,")
        append("maxRuntimePerTrainingJobInSeconds=$maxRuntimePerTrainingJobInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAutoMlJobRuntimeInSeconds ?: 0
        result = 31 * result + (maxCandidates ?: 0)
        result = 31 * result + (maxRuntimePerTrainingJobInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlJobCompletionCriteria

        if (maxAutoMlJobRuntimeInSeconds != other.maxAutoMlJobRuntimeInSeconds) return false
        if (maxCandidates != other.maxCandidates) return false
        if (maxRuntimePerTrainingJobInSeconds != other.maxRuntimePerTrainingJobInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum runtime, in seconds, an AutoML job has to complete.
         *
         * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, are not completed.
         */
        public var maxAutoMlJobRuntimeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of times a training job is allowed to run.
         *
         * For text and image classification, time-series forecasting, as well as text generation (LLMs fine-tuning) problem types, the supported value is 1. For tabular problem types, the maximum value is 750.
         */
        public var maxCandidates: kotlin.Int? = null
        /**
         * The maximum time, in seconds, that each training job executed inside hyperparameter tuning is allowed to run as part of a hyperparameter tuning job. For more information, see the [StoppingCondition](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html) used by the [CreateHyperParameterTuningJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html) action.
         *
         * For job V2s (jobs created by calling `CreateAutoMLJobV2`), this field controls the runtime of the job candidate.
         *
         * For [TextGenerationJobConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TextClassificationJobConfig.html) problem types, the maximum time defaults to 72 hours (259200 seconds).
         */
        public var maxRuntimePerTrainingJobInSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria) : this() {
            this.maxAutoMlJobRuntimeInSeconds = x.maxAutoMlJobRuntimeInSeconds
            this.maxCandidates = x.maxCandidates
            this.maxRuntimePerTrainingJobInSeconds = x.maxRuntimePerTrainingJobInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = AutoMlJobCompletionCriteria(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
