// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This data type is intended for use exclusively by SageMaker Canvas and cannot be used in other contexts at the moment.
 *
 * Specifies the compute configuration for an AutoML job V2.
 */
public class AutoMlComputeConfig private constructor(builder: Builder) {
    /**
     * The configuration for using [ EMR Serverless](https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html) to run the AutoML job V2.
     *
     * To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional compute resources are needed to process large datasets, you need to provide an `EmrServerlessComputeConfig` object, which includes an `ExecutionRoleARN` attribute, to the `AutoMLComputeConfig` of the AutoML job V2 input request.
     *
     * By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that would otherwise exceed the initially provisioned resources, without any manual intervention from you.
     *
     * EMR Serverless is available for the tabular and time series problem types. We recommend setting up this option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
     */
    public val emrServerlessComputeConfig: aws.sdk.kotlin.services.sagemaker.model.EmrServerlessComputeConfig? = builder.emrServerlessComputeConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlComputeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlComputeConfig(")
        append("emrServerlessComputeConfig=$emrServerlessComputeConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = emrServerlessComputeConfig?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlComputeConfig

        if (emrServerlessComputeConfig != other.emrServerlessComputeConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlComputeConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for using [ EMR Serverless](https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/emr-serverless.html) to run the AutoML job V2.
         *
         * To allow your AutoML job V2 to automatically initiate a remote job on EMR Serverless when additional compute resources are needed to process large datasets, you need to provide an `EmrServerlessComputeConfig` object, which includes an `ExecutionRoleARN` attribute, to the `AutoMLComputeConfig` of the AutoML job V2 input request.
         *
         * By seamlessly transitioning to EMR Serverless when required, the AutoML job can handle datasets that would otherwise exceed the initially provisioned resources, without any manual intervention from you.
         *
         * EMR Serverless is available for the tabular and time series problem types. We recommend setting up this option for tabular datasets larger than 5 GB and time series datasets larger than 30 GB.
         */
        public var emrServerlessComputeConfig: aws.sdk.kotlin.services.sagemaker.model.EmrServerlessComputeConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlComputeConfig) : this() {
            this.emrServerlessComputeConfig = x.emrServerlessComputeConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlComputeConfig = AutoMlComputeConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.EmrServerlessComputeConfig] inside the given [block]
         */
        public fun emrServerlessComputeConfig(block: aws.sdk.kotlin.services.sagemaker.model.EmrServerlessComputeConfig.Builder.() -> kotlin.Unit) {
            this.emrServerlessComputeConfig = aws.sdk.kotlin.services.sagemaker.model.EmrServerlessComputeConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
