// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The selection of algorithms trained on your dataset to generate the model candidates for an Autopilot job.
 */
public class AutoMlAlgorithmConfig private constructor(builder: Builder) {
    /**
     * The selection of algorithms trained on your dataset to generate the model candidates for an Autopilot job.
     * + **For the tabular problem type `TabularJobConfig`:**Selected algorithms must belong to the list corresponding to the training mode set in [AutoMLJobConfig.Mode](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode) (`ENSEMBLING` or `HYPERPARAMETER_TUNING`). Choose a minimum of 1 algorithm.   + In `ENSEMBLING` mode:
     *       + "catboost"
     *       + "extra-trees"
     *       + "fastai"
     *       + "lightgbm"
     *       + "linear-learner"
     *       + "nn-torch"
     *       + "randomforest"
     *       + "xgboost"
     *    + In `HYPERPARAMETER_TUNING` mode:
     *       + "linear-learner"
     *       + "mlp"
     *       + "xgboost"
     * + **For the time-series forecasting problem type `TimeSeriesForecastingJobConfig`:**
     *    + Choose your algorithms from this list.
     *       + "cnn-qr"
     *       + "deepar"
     *       + "prophet"
     *       + "arima"
     *       + "npts"
     *       + "ets"
     */
    public val autoMlAlgorithms: List<AutoMlAlgorithm>? = builder.autoMlAlgorithms

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlAlgorithmConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlAlgorithmConfig(")
        append("autoMlAlgorithms=$autoMlAlgorithms")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMlAlgorithms?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlAlgorithmConfig

        if (autoMlAlgorithms != other.autoMlAlgorithms) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlAlgorithmConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The selection of algorithms trained on your dataset to generate the model candidates for an Autopilot job.
         * + **For the tabular problem type `TabularJobConfig`:**Selected algorithms must belong to the list corresponding to the training mode set in [AutoMLJobConfig.Mode](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode) (`ENSEMBLING` or `HYPERPARAMETER_TUNING`). Choose a minimum of 1 algorithm.   + In `ENSEMBLING` mode:
         *       + "catboost"
         *       + "extra-trees"
         *       + "fastai"
         *       + "lightgbm"
         *       + "linear-learner"
         *       + "nn-torch"
         *       + "randomforest"
         *       + "xgboost"
         *    + In `HYPERPARAMETER_TUNING` mode:
         *       + "linear-learner"
         *       + "mlp"
         *       + "xgboost"
         * + **For the time-series forecasting problem type `TimeSeriesForecastingJobConfig`:**
         *    + Choose your algorithms from this list.
         *       + "cnn-qr"
         *       + "deepar"
         *       + "prophet"
         *       + "arima"
         *       + "npts"
         *       + "ets"
         */
        public var autoMlAlgorithms: List<AutoMlAlgorithm>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlAlgorithmConfig) : this() {
            this.autoMlAlgorithms = x.autoMlAlgorithms
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlAlgorithmConfig = AutoMlAlgorithmConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
