// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a training job and a batch transform job that SageMaker runs to validate your algorithm.
 *
 * The data provided in the validation profile is made available to your buyers on Amazon Web Services Marketplace.
 */
public class AlgorithmValidationProfile private constructor(builder: Builder) {
    /**
     * The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
     */
    public val profileName: kotlin.String? = builder.profileName
    /**
     * The `TrainingJobDefinition` object that describes the training job that SageMaker runs to validate your algorithm.
     */
    public val trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition? = builder.trainingJobDefinition
    /**
     * The `TransformJobDefinition` object that describes the transform job that SageMaker runs to validate your algorithm.
     */
    public val transformJobDefinition: aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition? = builder.transformJobDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlgorithmValidationProfile(")
        append("profileName=$profileName,")
        append("trainingJobDefinition=$trainingJobDefinition,")
        append("transformJobDefinition=$transformJobDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = profileName?.hashCode() ?: 0
        result = 31 * result + (trainingJobDefinition?.hashCode() ?: 0)
        result = 31 * result + (transformJobDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlgorithmValidationProfile

        if (profileName != other.profileName) return false
        if (trainingJobDefinition != other.trainingJobDefinition) return false
        if (transformJobDefinition != other.transformJobDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationProfile = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
         */
        public var profileName: kotlin.String? = null
        /**
         * The `TrainingJobDefinition` object that describes the training job that SageMaker runs to validate your algorithm.
         */
        public var trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition? = null
        /**
         * The `TransformJobDefinition` object that describes the transform job that SageMaker runs to validate your algorithm.
         */
        public var transformJobDefinition: aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationProfile) : this() {
            this.profileName = x.profileName
            this.trainingJobDefinition = x.trainingJobDefinition
            this.transformJobDefinition = x.transformJobDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AlgorithmValidationProfile = AlgorithmValidationProfile(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition] inside the given [block]
         */
        public fun trainingJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition.Builder.() -> kotlin.Unit) {
            this.trainingJobDefinition = aws.sdk.kotlin.services.sagemaker.model.TrainingJobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition] inside the given [block]
         */
        public fun transformJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition.Builder.() -> kotlin.Unit) {
            this.transformJobDefinition = aws.sdk.kotlin.services.sagemaker.model.TransformJobDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
