// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.HubContentType
import aws.sdk.kotlin.services.sagemaker.model.ImportHubContentRequest
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportHubContentOperationSerializer: HttpSerializer.NonStreaming<ImportHubContentRequest> {
    override fun serialize(context: ExecutionContext, input: ImportHubContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeImportHubContentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeImportHubContentOperationBody(context: ExecutionContext, input: ImportHubContentRequest): ByteArray {
    val serializer = JsonSerializer()
    val DOCUMENTSCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentSchemaVersion"))
    val HUBCONTENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDescription"))
    val HUBCONTENTDISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDisplayName"))
    val HUBCONTENTDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentDocument"))
    val HUBCONTENTMARKDOWN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentMarkdown"))
    val HUBCONTENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentName"))
    val HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("HubContentSearchKeywords"))
    val HUBCONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("HubContentType"))
    val HUBCONTENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubContentVersion"))
    val HUBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTSCHEMAVERSION_DESCRIPTOR)
        field(HUBCONTENTDESCRIPTION_DESCRIPTOR)
        field(HUBCONTENTDISPLAYNAME_DESCRIPTOR)
        field(HUBCONTENTDOCUMENT_DESCRIPTOR)
        field(HUBCONTENTMARKDOWN_DESCRIPTOR)
        field(HUBCONTENTNAME_DESCRIPTOR)
        field(HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR)
        field(HUBCONTENTTYPE_DESCRIPTOR)
        field(HUBCONTENTVERSION_DESCRIPTOR)
        field(HUBNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.documentSchemaVersion?.let { field(DOCUMENTSCHEMAVERSION_DESCRIPTOR, it) }
        input.hubContentDescription?.let { field(HUBCONTENTDESCRIPTION_DESCRIPTOR, it) }
        input.hubContentDisplayName?.let { field(HUBCONTENTDISPLAYNAME_DESCRIPTOR, it) }
        input.hubContentDocument?.let { field(HUBCONTENTDOCUMENT_DESCRIPTOR, it) }
        input.hubContentMarkdown?.let { field(HUBCONTENTMARKDOWN_DESCRIPTOR, it) }
        input.hubContentName?.let { field(HUBCONTENTNAME_DESCRIPTOR, it) }
        if (input.hubContentSearchKeywords != null) {
            listField(HUBCONTENTSEARCHKEYWORDS_DESCRIPTOR) {
                for (el0 in input.hubContentSearchKeywords) {
                    serializeString(el0)
                }
            }
        }
        input.hubContentType?.let { field(HUBCONTENTTYPE_DESCRIPTOR, it.value) }
        input.hubContentVersion?.let { field(HUBCONTENTVERSION_DESCRIPTOR, it) }
        input.hubName?.let { field(HUBNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
