// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.DescribeNotebookInstanceResponse
import aws.sdk.kotlin.services.sagemaker.model.DirectInternetAccess
import aws.sdk.kotlin.services.sagemaker.model.InstanceMetadataServiceConfiguration
import aws.sdk.kotlin.services.sagemaker.model.InstanceType
import aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceAcceleratorType
import aws.sdk.kotlin.services.sagemaker.model.NotebookInstanceStatus
import aws.sdk.kotlin.services.sagemaker.model.RootAccess
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeNotebookInstanceOperationDeserializer: HttpDeserializer.NonStreaming<DescribeNotebookInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeNotebookInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeNotebookInstanceError(context, call, payload)
        }
        val builder = DescribeNotebookInstanceResponse.Builder()

        if (payload != null) {
            deserializeDescribeNotebookInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeNotebookInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNotebookInstanceOperationBody(builder: DescribeNotebookInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCELERATORTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AcceleratorTypes"))
    val ADDITIONALCODEREPOSITORIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdditionalCodeRepositories"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DEFAULTCODEREPOSITORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultCodeRepository"))
    val DIRECTINTERNETACCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DirectInternetAccess"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val INSTANCEMETADATASERVICECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InstanceMetadataServiceConfiguration"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("InstanceType"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val NETWORKINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NetworkInterfaceId"))
    val NOTEBOOKINSTANCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceArn"))
    val NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceLifecycleConfigName"))
    val NOTEBOOKINSTANCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotebookInstanceName"))
    val NOTEBOOKINSTANCESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("NotebookInstanceStatus"))
    val PLATFORMIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlatformIdentifier"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val ROOTACCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("RootAccess"))
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityGroups"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetId"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val VOLUMESIZEINGB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("VolumeSizeInGB"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCELERATORTYPES_DESCRIPTOR)
        field(ADDITIONALCODEREPOSITORIES_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DEFAULTCODEREPOSITORY_DESCRIPTOR)
        field(DIRECTINTERNETACCESS_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(INSTANCEMETADATASERVICECONFIGURATION_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NETWORKINTERFACEID_DESCRIPTOR)
        field(NOTEBOOKINSTANCEARN_DESCRIPTOR)
        field(NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR)
        field(NOTEBOOKINSTANCENAME_DESCRIPTOR)
        field(NOTEBOOKINSTANCESTATUS_DESCRIPTOR)
        field(PLATFORMIDENTIFIER_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(ROOTACCESS_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(URL_DESCRIPTOR)
        field(VOLUMESIZEINGB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCELERATORTYPES_DESCRIPTOR.index -> builder.acceleratorTypes =
                    deserializer.deserializeList(ACCELERATORTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<NotebookInstanceAcceleratorType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { NotebookInstanceAcceleratorType.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ADDITIONALCODEREPOSITORIES_DESCRIPTOR.index -> builder.additionalCodeRepositories =
                    deserializer.deserializeList(ADDITIONALCODEREPOSITORIES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEFAULTCODEREPOSITORY_DESCRIPTOR.index -> builder.defaultCodeRepository = deserializeString()
                DIRECTINTERNETACCESS_DESCRIPTOR.index -> builder.directInternetAccess = deserializeString().let { DirectInternetAccess.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                INSTANCEMETADATASERVICECONFIGURATION_DESCRIPTOR.index -> builder.instanceMetadataServiceConfiguration = deserializeInstanceMetadataServiceConfigurationDocument(deserializer)
                INSTANCETYPE_DESCRIPTOR.index -> builder.instanceType = deserializeString().let { InstanceType.fromValue(it) }
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NETWORKINTERFACEID_DESCRIPTOR.index -> builder.networkInterfaceId = deserializeString()
                NOTEBOOKINSTANCEARN_DESCRIPTOR.index -> builder.notebookInstanceArn = deserializeString()
                NOTEBOOKINSTANCELIFECYCLECONFIGNAME_DESCRIPTOR.index -> builder.notebookInstanceLifecycleConfigName = deserializeString()
                NOTEBOOKINSTANCENAME_DESCRIPTOR.index -> builder.notebookInstanceName = deserializeString()
                NOTEBOOKINSTANCESTATUS_DESCRIPTOR.index -> builder.notebookInstanceStatus = deserializeString().let { NotebookInstanceStatus.fromValue(it) }
                PLATFORMIDENTIFIER_DESCRIPTOR.index -> builder.platformIdentifier = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                ROOTACCESS_DESCRIPTOR.index -> builder.rootAccess = deserializeString().let { RootAccess.fromValue(it) }
                SECURITYGROUPS_DESCRIPTOR.index -> builder.securityGroups =
                    deserializer.deserializeList(SECURITYGROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBNETID_DESCRIPTOR.index -> builder.subnetId = deserializeString()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                VOLUMESIZEINGB_DESCRIPTOR.index -> builder.volumeSizeInGb = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
