// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AutoMlCandidate
import aws.sdk.kotlin.services.sagemaker.model.AutoMlDataSplitConfig
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobArtifacts
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobChannel
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobObjective
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobSecondaryStatus
import aws.sdk.kotlin.services.sagemaker.model.AutoMlJobStatus
import aws.sdk.kotlin.services.sagemaker.model.AutoMlOutputDataConfig
import aws.sdk.kotlin.services.sagemaker.model.AutoMlPartialFailureReason
import aws.sdk.kotlin.services.sagemaker.model.AutoMlProblemTypeConfig
import aws.sdk.kotlin.services.sagemaker.model.AutoMlProblemTypeConfigName
import aws.sdk.kotlin.services.sagemaker.model.AutoMlResolvedAttributes
import aws.sdk.kotlin.services.sagemaker.model.AutoMlSecurityConfig
import aws.sdk.kotlin.services.sagemaker.model.DescribeAutoMlJobV2Response
import aws.sdk.kotlin.services.sagemaker.model.ModelDeployConfig
import aws.sdk.kotlin.services.sagemaker.model.ModelDeployResult
import aws.sdk.kotlin.services.sagemaker.model.SageMakerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeAutoMLJobV2OperationDeserializer: HttpDeserializer.NonStreaming<DescribeAutoMlJobV2Response> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeAutoMlJobV2Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeAutoMlJobV2Error(context, call, payload)
        }
        val builder = DescribeAutoMlJobV2Response.Builder()

        if (payload != null) {
            deserializeDescribeAutoMLJobV2OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeAutoMlJobV2Error(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SageMakerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFound" -> ResourceNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> SageMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeAutoMLJobV2OperationBody(builder: DescribeAutoMlJobV2Response.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOMLJOBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobArn"))
    val AUTOMLJOBARTIFACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLJobArtifacts"))
    val AUTOMLJOBINPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AutoMLJobInputDataConfig"))
    val AUTOMLJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AutoMLJobName"))
    val AUTOMLJOBOBJECTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLJobObjective"))
    val AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLJobSecondaryStatus"))
    val AUTOMLJOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLJobStatus"))
    val AUTOMLPROBLEMTYPECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AutoMLProblemTypeConfig"))
    val AUTOMLPROBLEMTYPECONFIGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AutoMLProblemTypeConfigName"))
    val BESTCANDIDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BestCandidate"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DATASPLITCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DataSplitConfig"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val MODELDEPLOYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelDeployConfig"))
    val MODELDEPLOYRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelDeployResult"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputDataConfig"))
    val PARTIALFAILUREREASONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PartialFailureReasons"))
    val RESOLVEDATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResolvedAttributes"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SECURITYCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SecurityConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOMLJOBARN_DESCRIPTOR)
        field(AUTOMLJOBARTIFACTS_DESCRIPTOR)
        field(AUTOMLJOBINPUTDATACONFIG_DESCRIPTOR)
        field(AUTOMLJOBNAME_DESCRIPTOR)
        field(AUTOMLJOBOBJECTIVE_DESCRIPTOR)
        field(AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR)
        field(AUTOMLJOBSTATUS_DESCRIPTOR)
        field(AUTOMLPROBLEMTYPECONFIG_DESCRIPTOR)
        field(AUTOMLPROBLEMTYPECONFIGNAME_DESCRIPTOR)
        field(BESTCANDIDATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATASPLITCONFIG_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(MODELDEPLOYCONFIG_DESCRIPTOR)
        field(MODELDEPLOYRESULT_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(PARTIALFAILUREREASONS_DESCRIPTOR)
        field(RESOLVEDATTRIBUTES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SECURITYCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOMLJOBARN_DESCRIPTOR.index -> builder.autoMlJobArn = deserializeString()
                AUTOMLJOBARTIFACTS_DESCRIPTOR.index -> builder.autoMlJobArtifacts = deserializeAutoMlJobArtifactsDocument(deserializer)
                AUTOMLJOBINPUTDATACONFIG_DESCRIPTOR.index -> builder.autoMlJobInputDataConfig =
                    deserializer.deserializeList(AUTOMLJOBINPUTDATACONFIG_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoMlJobChannel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoMlJobChannelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTOMLJOBNAME_DESCRIPTOR.index -> builder.autoMlJobName = deserializeString()
                AUTOMLJOBOBJECTIVE_DESCRIPTOR.index -> builder.autoMlJobObjective = deserializeAutoMlJobObjectiveDocument(deserializer)
                AUTOMLJOBSECONDARYSTATUS_DESCRIPTOR.index -> builder.autoMlJobSecondaryStatus = deserializeString().let { AutoMlJobSecondaryStatus.fromValue(it) }
                AUTOMLJOBSTATUS_DESCRIPTOR.index -> builder.autoMlJobStatus = deserializeString().let { AutoMlJobStatus.fromValue(it) }
                AUTOMLPROBLEMTYPECONFIG_DESCRIPTOR.index -> builder.autoMlProblemTypeConfig = deserializeAutoMlProblemTypeConfigDocument(deserializer)
                AUTOMLPROBLEMTYPECONFIGNAME_DESCRIPTOR.index -> builder.autoMlProblemTypeConfigName = deserializeString().let { AutoMlProblemTypeConfigName.fromValue(it) }
                BESTCANDIDATE_DESCRIPTOR.index -> builder.bestCandidate = deserializeAutoMlCandidateDocument(deserializer)
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATASPLITCONFIG_DESCRIPTOR.index -> builder.dataSplitConfig = deserializeAutoMlDataSplitConfigDocument(deserializer)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELDEPLOYCONFIG_DESCRIPTOR.index -> builder.modelDeployConfig = deserializeModelDeployConfigDocument(deserializer)
                MODELDEPLOYRESULT_DESCRIPTOR.index -> builder.modelDeployResult = deserializeModelDeployResultDocument(deserializer)
                OUTPUTDATACONFIG_DESCRIPTOR.index -> builder.outputDataConfig = deserializeAutoMlOutputDataConfigDocument(deserializer)
                PARTIALFAILUREREASONS_DESCRIPTOR.index -> builder.partialFailureReasons =
                    deserializer.deserializeList(PARTIALFAILUREREASONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoMlPartialFailureReason>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoMlPartialFailureReasonDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOLVEDATTRIBUTES_DESCRIPTOR.index -> builder.resolvedAttributes = deserializeAutoMlResolvedAttributesDocument(deserializer)
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SECURITYCONFIG_DESCRIPTOR.index -> builder.securityConfig = deserializeAutoMlSecurityConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
