// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification
import aws.sdk.kotlin.services.sagemaker.model.Channel
import aws.sdk.kotlin.services.sagemaker.model.CheckpointConfig
import aws.sdk.kotlin.services.sagemaker.model.CreateTrainingJobRequest
import aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig
import aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration
import aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig
import aws.sdk.kotlin.services.sagemaker.model.InfraCheckConfig
import aws.sdk.kotlin.services.sagemaker.model.OutputDataConfig
import aws.sdk.kotlin.services.sagemaker.model.ProfilerConfig
import aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration
import aws.sdk.kotlin.services.sagemaker.model.RemoteDebugConfig
import aws.sdk.kotlin.services.sagemaker.model.ResourceConfig
import aws.sdk.kotlin.services.sagemaker.model.RetryStrategy
import aws.sdk.kotlin.services.sagemaker.model.SessionChainingConfig
import aws.sdk.kotlin.services.sagemaker.model.StoppingCondition
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.sdk.kotlin.services.sagemaker.model.TensorBoardOutputConfig
import aws.sdk.kotlin.services.sagemaker.model.VpcConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTrainingJobOperationSerializer: HttpSerializer.NonStreaming<CreateTrainingJobRequest> {
    override fun serialize(context: ExecutionContext, input: CreateTrainingJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateTrainingJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateTrainingJobOperationBody(context: ExecutionContext, input: CreateTrainingJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALGORITHMSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlgorithmSpecification"))
    val CHECKPOINTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CheckpointConfig"))
    val DEBUGHOOKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DebugHookConfig"))
    val DEBUGRULECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DebugRuleConfigurations"))
    val ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableInterContainerTrafficEncryption"))
    val ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableManagedSpotTraining"))
    val ENABLENETWORKISOLATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("EnableNetworkIsolation"))
    val ENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Environment"))
    val EXPERIMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperimentConfig"))
    val HYPERPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("HyperParameters"))
    val INFRACHECKCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InfraCheckConfig"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InputDataConfig"))
    val OUTPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputDataConfig"))
    val PROFILERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProfilerConfig"))
    val PROFILERRULECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProfilerRuleConfigurations"))
    val REMOTEDEBUGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RemoteDebugConfig"))
    val RESOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceConfig"))
    val RETRYSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RetryStrategy"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SESSIONCHAININGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SessionChainingConfig"))
    val STOPPINGCONDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StoppingCondition"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TENSORBOARDOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TensorBoardOutputConfig"))
    val TRAININGJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrainingJobName"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALGORITHMSPECIFICATION_DESCRIPTOR)
        field(CHECKPOINTCONFIG_DESCRIPTOR)
        field(DEBUGHOOKCONFIG_DESCRIPTOR)
        field(DEBUGRULECONFIGURATIONS_DESCRIPTOR)
        field(ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR)
        field(ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR)
        field(ENABLENETWORKISOLATION_DESCRIPTOR)
        field(ENVIRONMENT_DESCRIPTOR)
        field(EXPERIMENTCONFIG_DESCRIPTOR)
        field(HYPERPARAMETERS_DESCRIPTOR)
        field(INFRACHECKCONFIG_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(OUTPUTDATACONFIG_DESCRIPTOR)
        field(PROFILERCONFIG_DESCRIPTOR)
        field(PROFILERRULECONFIGURATIONS_DESCRIPTOR)
        field(REMOTEDEBUGCONFIG_DESCRIPTOR)
        field(RESOURCECONFIG_DESCRIPTOR)
        field(RETRYSTRATEGY_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SESSIONCHAININGCONFIG_DESCRIPTOR)
        field(STOPPINGCONDITION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TENSORBOARDOUTPUTCONFIG_DESCRIPTOR)
        field(TRAININGJOBNAME_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.algorithmSpecification?.let { field(ALGORITHMSPECIFICATION_DESCRIPTOR, it, ::serializeAlgorithmSpecificationDocument) }
        input.checkpointConfig?.let { field(CHECKPOINTCONFIG_DESCRIPTOR, it, ::serializeCheckpointConfigDocument) }
        input.debugHookConfig?.let { field(DEBUGHOOKCONFIG_DESCRIPTOR, it, ::serializeDebugHookConfigDocument) }
        if (input.debugRuleConfigurations != null) {
            listField(DEBUGRULECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.debugRuleConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDebugRuleConfigurationDocument))
                }
            }
        }
        input.enableInterContainerTrafficEncryption?.let { field(ENABLEINTERCONTAINERTRAFFICENCRYPTION_DESCRIPTOR, it) }
        input.enableManagedSpotTraining?.let { field(ENABLEMANAGEDSPOTTRAINING_DESCRIPTOR, it) }
        input.enableNetworkIsolation?.let { field(ENABLENETWORKISOLATION_DESCRIPTOR, it) }
        if (input.environment != null) {
            mapField(ENVIRONMENT_DESCRIPTOR) {
                input.environment.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.experimentConfig?.let { field(EXPERIMENTCONFIG_DESCRIPTOR, it, ::serializeExperimentConfigDocument) }
        if (input.hyperParameters != null) {
            mapField(HYPERPARAMETERS_DESCRIPTOR) {
                input.hyperParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.infraCheckConfig?.let { field(INFRACHECKCONFIG_DESCRIPTOR, it, ::serializeInfraCheckConfigDocument) }
        if (input.inputDataConfig != null) {
            listField(INPUTDATACONFIG_DESCRIPTOR) {
                for (el0 in input.inputDataConfig) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeChannelDocument))
                }
            }
        }
        input.outputDataConfig?.let { field(OUTPUTDATACONFIG_DESCRIPTOR, it, ::serializeOutputDataConfigDocument) }
        input.profilerConfig?.let { field(PROFILERCONFIG_DESCRIPTOR, it, ::serializeProfilerConfigDocument) }
        if (input.profilerRuleConfigurations != null) {
            listField(PROFILERRULECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.profilerRuleConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProfilerRuleConfigurationDocument))
                }
            }
        }
        input.remoteDebugConfig?.let { field(REMOTEDEBUGCONFIG_DESCRIPTOR, it, ::serializeRemoteDebugConfigDocument) }
        input.resourceConfig?.let { field(RESOURCECONFIG_DESCRIPTOR, it, ::serializeResourceConfigDocument) }
        input.retryStrategy?.let { field(RETRYSTRATEGY_DESCRIPTOR, it, ::serializeRetryStrategyDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.sessionChainingConfig?.let { field(SESSIONCHAININGCONFIG_DESCRIPTOR, it, ::serializeSessionChainingConfigDocument) }
        input.stoppingCondition?.let { field(STOPPINGCONDITION_DESCRIPTOR, it, ::serializeStoppingConditionDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tensorBoardOutputConfig?.let { field(TENSORBOARDOUTPUTCONFIG_DESCRIPTOR, it, ::serializeTensorBoardOutputConfigDocument) }
        input.trainingJobName?.let { field(TRAININGJOBNAME_DESCRIPTOR, it) }
        input.vpcConfig?.let { field(VPCCONFIG_DESCRIPTOR, it, ::serializeVpcConfigDocument) }
    }
    return serializer.toByteArray()
}
