// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.serde

import aws.sdk.kotlin.services.sagemaker.model.ActionSource
import aws.sdk.kotlin.services.sagemaker.model.ActionStatus
import aws.sdk.kotlin.services.sagemaker.model.CreateActionRequest
import aws.sdk.kotlin.services.sagemaker.model.MetadataProperties
import aws.sdk.kotlin.services.sagemaker.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateActionOperationSerializer: HttpSerializer.NonStreaming<CreateActionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateActionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateActionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateActionOperationBody(context: ExecutionContext, input: CreateActionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionName"))
    val ACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActionType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val METADATAPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MetadataProperties"))
    val PROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Properties"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Source"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONNAME_DESCRIPTOR)
        field(ACTIONTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(METADATAPROPERTIES_DESCRIPTOR)
        field(PROPERTIES_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionName?.let { field(ACTIONNAME_DESCRIPTOR, it) }
        input.actionType?.let { field(ACTIONTYPE_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.metadataProperties?.let { field(METADATAPROPERTIES_DESCRIPTOR, it, ::serializeMetadataPropertiesDocument) }
        if (input.properties != null) {
            mapField(PROPERTIES_DESCRIPTOR) {
                input.properties.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.source?.let { field(SOURCE_DESCRIPTOR, it, ::serializeActionSourceDocument) }
        input.status?.let { field(STATUS_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
