// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies mandatory fields for running an Inference Recommender job directly in the [CreateInferenceRecommendationsJob](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html) API. The fields specified in `ContainerConfig` override the corresponding fields in the model package. Use `ContainerConfig` if you want to specify these fields for the recommendation job but don't want to edit them in your model package.
 */
public class RecommendationJobContainerConfig private constructor(builder: Builder) {
    /**
     * Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. This field is used for optimizing your model using SageMaker Neo. For more information, see [DataInputConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_InputConfig.html#sagemaker-Type-InputConfig-DataInputConfig).
     */
    public val dataInputConfig: kotlin.String? = builder.dataInputConfig
    /**
     * The machine learning domain of the model and its components.
     *
     * Valid Values: `COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING`
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The machine learning framework of the container image.
     *
     * Valid Values: `TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN`
     */
    public val framework: kotlin.String? = builder.framework
    /**
     * The framework version of the container image.
     */
    public val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender that matches your model.
     *
     * Valid Values: `efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet`
     */
    public val nearestModelName: kotlin.String? = builder.nearestModelName
    /**
     * Specifies the `SamplePayloadUrl` and all other sample payload-related fields.
     */
    public val payloadConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobPayloadConfig? = builder.payloadConfig
    /**
     * The endpoint type to receive recommendations for. By default this is null, and the results of the inference recommendation job return a combined list of both real-time and serverless benchmarks. By specifying a value for this field, you can receive a longer list of benchmarks for the desired endpoint type.
     */
    public val supportedEndpointType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobSupportedEndpointType? = builder.supportedEndpointType
    /**
     * A list of the instance types that are used to generate inferences in real-time.
     */
    public val supportedInstanceTypes: List<String>? = builder.supportedInstanceTypes
    /**
     * The supported MIME types for the output data.
     */
    public val supportedResponseMimeTypes: List<String>? = builder.supportedResponseMimeTypes
    /**
     * The machine learning task that the model accomplishes.
     *
     * Valid Values: `IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER`
     */
    public val task: kotlin.String? = builder.task

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationJobContainerConfig(")
        append("dataInputConfig=$dataInputConfig,")
        append("domain=$domain,")
        append("framework=$framework,")
        append("frameworkVersion=$frameworkVersion,")
        append("nearestModelName=$nearestModelName,")
        append("payloadConfig=$payloadConfig,")
        append("supportedEndpointType=$supportedEndpointType,")
        append("supportedInstanceTypes=$supportedInstanceTypes,")
        append("supportedResponseMimeTypes=$supportedResponseMimeTypes,")
        append("task=$task")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataInputConfig?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (nearestModelName?.hashCode() ?: 0)
        result = 31 * result + (payloadConfig?.hashCode() ?: 0)
        result = 31 * result + (supportedEndpointType?.hashCode() ?: 0)
        result = 31 * result + (supportedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedResponseMimeTypes?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationJobContainerConfig

        if (dataInputConfig != other.dataInputConfig) return false
        if (domain != other.domain) return false
        if (framework != other.framework) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (nearestModelName != other.nearestModelName) return false
        if (payloadConfig != other.payloadConfig) return false
        if (supportedEndpointType != other.supportedEndpointType) return false
        if (supportedInstanceTypes != other.supportedInstanceTypes) return false
        if (supportedResponseMimeTypes != other.supportedResponseMimeTypes) return false
        if (task != other.task) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. This field is used for optimizing your model using SageMaker Neo. For more information, see [DataInputConfig](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_InputConfig.html#sagemaker-Type-InputConfig-DataInputConfig).
         */
        public var dataInputConfig: kotlin.String? = null
        /**
         * The machine learning domain of the model and its components.
         *
         * Valid Values: `COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING`
         */
        public var domain: kotlin.String? = null
        /**
         * The machine learning framework of the container image.
         *
         * Valid Values: `TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN`
         */
        public var framework: kotlin.String? = null
        /**
         * The framework version of the container image.
         */
        public var frameworkVersion: kotlin.String? = null
        /**
         * The name of a pre-trained machine learning model benchmarked by Amazon SageMaker Inference Recommender that matches your model.
         *
         * Valid Values: `efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 | nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn | densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 | resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet`
         */
        public var nearestModelName: kotlin.String? = null
        /**
         * Specifies the `SamplePayloadUrl` and all other sample payload-related fields.
         */
        public var payloadConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobPayloadConfig? = null
        /**
         * The endpoint type to receive recommendations for. By default this is null, and the results of the inference recommendation job return a combined list of both real-time and serverless benchmarks. By specifying a value for this field, you can receive a longer list of benchmarks for the desired endpoint type.
         */
        public var supportedEndpointType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobSupportedEndpointType? = null
        /**
         * A list of the instance types that are used to generate inferences in real-time.
         */
        public var supportedInstanceTypes: List<String>? = null
        /**
         * The supported MIME types for the output data.
         */
        public var supportedResponseMimeTypes: List<String>? = null
        /**
         * The machine learning task that the model accomplishes.
         *
         * Valid Values: `IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION | IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER`
         */
        public var task: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig) : this() {
            this.dataInputConfig = x.dataInputConfig
            this.domain = x.domain
            this.framework = x.framework
            this.frameworkVersion = x.frameworkVersion
            this.nearestModelName = x.nearestModelName
            this.payloadConfig = x.payloadConfig
            this.supportedEndpointType = x.supportedEndpointType
            this.supportedInstanceTypes = x.supportedInstanceTypes
            this.supportedResponseMimeTypes = x.supportedResponseMimeTypes
            this.task = x.task
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.RecommendationJobContainerConfig = RecommendationJobContainerConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobPayloadConfig] inside the given [block]
         */
        public fun payloadConfig(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobPayloadConfig.Builder.() -> kotlin.Unit) {
            this.payloadConfig = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobPayloadConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
