// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information for profiling rules.
 */
public class ProfilerRuleConfiguration private constructor(builder: Builder) {
    /**
     * The instance type to deploy a custom rule for profiling a training job.
     */
    public val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = builder.instanceType
    /**
     * Path to local storage location for output of rules. Defaults to `/opt/ml/processing/output/rule/`.
     */
    public val localPath: kotlin.String? = builder.localPath
    /**
     * The name of the rule configuration. It must be unique relative to other rule configuration names.
     */
    public val ruleConfigurationName: kotlin.String? = builder.ruleConfigurationName
    /**
     * The Amazon Elastic Container Registry Image for the managed rule evaluation.
     */
    public val ruleEvaluatorImage: kotlin.String? = builder.ruleEvaluatorImage
    /**
     * Runtime configuration for rule container.
     */
    public val ruleParameters: Map<String, String>? = builder.ruleParameters
    /**
     * Path to Amazon S3 storage location for rules.
     */
    public val s3OutputPath: kotlin.String? = builder.s3OutputPath
    /**
     * The size, in GB, of the ML storage volume attached to the processing instance.
     */
    public val volumeSizeInGb: kotlin.Int? = builder.volumeSizeInGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilerRuleConfiguration(")
        append("instanceType=$instanceType,")
        append("localPath=$localPath,")
        append("ruleConfigurationName=$ruleConfigurationName,")
        append("ruleEvaluatorImage=$ruleEvaluatorImage,")
        append("ruleParameters=$ruleParameters,")
        append("s3OutputPath=$s3OutputPath,")
        append("volumeSizeInGb=$volumeSizeInGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (localPath?.hashCode() ?: 0)
        result = 31 * result + (ruleConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (ruleEvaluatorImage?.hashCode() ?: 0)
        result = 31 * result + (ruleParameters?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProfilerRuleConfiguration

        if (instanceType != other.instanceType) return false
        if (localPath != other.localPath) return false
        if (ruleConfigurationName != other.ruleConfigurationName) return false
        if (ruleEvaluatorImage != other.ruleEvaluatorImage) return false
        if (ruleParameters != other.ruleParameters) return false
        if (s3OutputPath != other.s3OutputPath) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instance type to deploy a custom rule for profiling a training job.
         */
        public var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = null
        /**
         * Path to local storage location for output of rules. Defaults to `/opt/ml/processing/output/rule/`.
         */
        public var localPath: kotlin.String? = null
        /**
         * The name of the rule configuration. It must be unique relative to other rule configuration names.
         */
        public var ruleConfigurationName: kotlin.String? = null
        /**
         * The Amazon Elastic Container Registry Image for the managed rule evaluation.
         */
        public var ruleEvaluatorImage: kotlin.String? = null
        /**
         * Runtime configuration for rule container.
         */
        public var ruleParameters: Map<String, String>? = null
        /**
         * Path to Amazon S3 storage location for rules.
         */
        public var s3OutputPath: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume attached to the processing instance.
         */
        public var volumeSizeInGb: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration) : this() {
            this.instanceType = x.instanceType
            this.localPath = x.localPath
            this.ruleConfigurationName = x.ruleConfigurationName
            this.ruleEvaluatorImage = x.ruleEvaluatorImage
            this.ruleParameters = x.ruleParameters
            this.s3OutputPath = x.s3OutputPath
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProfilerRuleConfiguration = ProfilerRuleConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
