// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the results of a processing job. The processing output must specify exactly one of either `S3Output` or `FeatureStoreOutput` types.
 */
public class ProcessingOutput private constructor(builder: Builder) {
    /**
     * When `True`, output operations such as data upload are managed natively by the processing job application. When `False` (default), output operations are managed by Amazon SageMaker.
     */
    public val appManaged: kotlin.Boolean? = builder.appManaged
    /**
     * Configuration for processing job outputs in Amazon SageMaker Feature Store. This processing output type is only supported when `AppManaged` is specified.
     */
    public val featureStoreOutput: aws.sdk.kotlin.services.sagemaker.model.ProcessingFeatureStoreOutput? = builder.featureStoreOutput
    /**
     * The name for the processing job output.
     */
    public val outputName: kotlin.String? = builder.outputName
    /**
     * Configuration for processing job outputs in Amazon S3.
     */
    public val s3Output: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Output? = builder.s3Output

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessingOutput(")
        append("appManaged=$appManaged,")
        append("featureStoreOutput=$featureStoreOutput,")
        append("outputName=$outputName,")
        append("s3Output=$s3Output")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appManaged?.hashCode() ?: 0
        result = 31 * result + (featureStoreOutput?.hashCode() ?: 0)
        result = 31 * result + (outputName?.hashCode() ?: 0)
        result = 31 * result + (s3Output?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessingOutput

        if (appManaged != other.appManaged) return false
        if (featureStoreOutput != other.featureStoreOutput) return false
        if (outputName != other.outputName) return false
        if (s3Output != other.s3Output) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When `True`, output operations such as data upload are managed natively by the processing job application. When `False` (default), output operations are managed by Amazon SageMaker.
         */
        public var appManaged: kotlin.Boolean? = null
        /**
         * Configuration for processing job outputs in Amazon SageMaker Feature Store. This processing output type is only supported when `AppManaged` is specified.
         */
        public var featureStoreOutput: aws.sdk.kotlin.services.sagemaker.model.ProcessingFeatureStoreOutput? = null
        /**
         * The name for the processing job output.
         */
        public var outputName: kotlin.String? = null
        /**
         * Configuration for processing job outputs in Amazon S3.
         */
        public var s3Output: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Output? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ProcessingOutput) : this() {
            this.appManaged = x.appManaged
            this.featureStoreOutput = x.featureStoreOutput
            this.outputName = x.outputName
            this.s3Output = x.s3Output
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ProcessingOutput = ProcessingOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingFeatureStoreOutput] inside the given [block]
         */
        public fun featureStoreOutput(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingFeatureStoreOutput.Builder.() -> kotlin.Unit) {
            this.featureStoreOutput = aws.sdk.kotlin.services.sagemaker.model.ProcessingFeatureStoreOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Output] inside the given [block]
         */
        public fun s3Output(block: aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Output.Builder.() -> kotlin.Unit) {
            this.s3Output = aws.sdk.kotlin.services.sagemaker.model.ProcessingS3Output.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
