// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the monitoring job.
 */
public class MonitoringJobDefinition private constructor(builder: Builder) {
    /**
     * Baseline configuration used to validate that the data conforms to the specified constraints and statistics
     */
    public val baselineConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig? = builder.baselineConfig
    /**
     * Sets the environment variables in the Docker container.
     */
    public val environment: Map<String, String>? = builder.environment
    /**
     * Configures the monitoring job to run a specified Docker container image.
     */
    public val monitoringAppSpecification: aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification? = builder.monitoringAppSpecification
    /**
     * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
     */
    public val monitoringInputs: List<MonitoringInput>? = builder.monitoringInputs
    /**
     * The array of outputs from the monitoring job to be uploaded to Amazon S3.
     */
    public val monitoringOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = builder.monitoringOutputConfig
    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.
     */
    public val monitoringResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = builder.monitoringResources
    /**
     * Specifies networking options for an monitoring job.
     */
    public val networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = builder.networkConfig
    /**
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies a time limit for how long the monitoring job is allowed to run.
     */
    public val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = builder.stoppingCondition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringJobDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringJobDefinition(")
        append("baselineConfig=$baselineConfig,")
        append("environment=$environment,")
        append("monitoringAppSpecification=$monitoringAppSpecification,")
        append("monitoringInputs=$monitoringInputs,")
        append("monitoringOutputConfig=$monitoringOutputConfig,")
        append("monitoringResources=$monitoringResources,")
        append("networkConfig=$networkConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineConfig?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (monitoringAppSpecification?.hashCode() ?: 0)
        result = 31 * result + (monitoringInputs?.hashCode() ?: 0)
        result = 31 * result + (monitoringOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (monitoringResources?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringJobDefinition

        if (baselineConfig != other.baselineConfig) return false
        if (environment != other.environment) return false
        if (monitoringAppSpecification != other.monitoringAppSpecification) return false
        if (monitoringInputs != other.monitoringInputs) return false
        if (monitoringOutputConfig != other.monitoringOutputConfig) return false
        if (monitoringResources != other.monitoringResources) return false
        if (networkConfig != other.networkConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringJobDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Baseline configuration used to validate that the data conforms to the specified constraints and statistics
         */
        public var baselineConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig? = null
        /**
         * Sets the environment variables in the Docker container.
         */
        public var environment: Map<String, String>? = null
        /**
         * Configures the monitoring job to run a specified Docker container image.
         */
        public var monitoringAppSpecification: aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification? = null
        /**
         * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
         */
        public var monitoringInputs: List<MonitoringInput>? = null
        /**
         * The array of outputs from the monitoring job to be uploaded to Amazon S3.
         */
        public var monitoringOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = null
        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.
         */
        public var monitoringResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = null
        /**
         * Specifies networking options for an monitoring job.
         */
        public var networkConfig: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies a time limit for how long the monitoring job is allowed to run.
         */
        public var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringJobDefinition) : this() {
            this.baselineConfig = x.baselineConfig
            this.environment = x.environment
            this.monitoringAppSpecification = x.monitoringAppSpecification
            this.monitoringInputs = x.monitoringInputs
            this.monitoringOutputConfig = x.monitoringOutputConfig
            this.monitoringResources = x.monitoringResources
            this.networkConfig = x.networkConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringJobDefinition = MonitoringJobDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig] inside the given [block]
         */
        public fun baselineConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig.Builder.() -> kotlin.Unit) {
            this.baselineConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringBaselineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification] inside the given [block]
         */
        public fun monitoringAppSpecification(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification.Builder.() -> kotlin.Unit) {
            this.monitoringAppSpecification = aws.sdk.kotlin.services.sagemaker.model.MonitoringAppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig] inside the given [block]
         */
        public fun monitoringOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.Builder.() -> kotlin.Unit) {
            this.monitoringOutputConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringResources] inside the given [block]
         */
        public fun monitoringResources(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.Builder.() -> kotlin.Unit) {
            this.monitoringResources = aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.NetworkConfig] inside the given [block]
         */
        public fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.NetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition] inside the given [block]
         */
        public fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
