// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A versioned model that can be deployed for SageMaker inference.
 */
public class ModelPackage private constructor(builder: Builder) {
    /**
     * An array of additional Inference Specification objects.
     */
    public val additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = builder.additionalInferenceSpecifications
    /**
     * A description provided when the model approval is set.
     */
    public val approvalDescription: kotlin.String? = builder.approvalDescription
    /**
     * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information about listing model packages on Amazon Web Services Marketplace, see [List Your Algorithm or Model Package on Amazon Web Services Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html).
     */
    public val certifyForMarketplace: kotlin.Boolean? = builder.certifyForMarketplace
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
     */
    public val createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.createdBy
    /**
     * The time that the model package was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The metadata properties for the model package.
     */
    public val customerMetadataProperties: Map<String, String>? = builder.customerMetadataProperties
    /**
     * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package.
     */
    public val driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = builder.driftCheckBaselines
    /**
     * Defines how to perform inference generation after a training job is run.
     */
    public val inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = builder.inferenceSpecification
    /**
     * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
     */
    public val lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = builder.lastModifiedBy
    /**
     * The last time the model package was modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    public val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * The approval status of the model. This can be one of the following values.
     * + `APPROVED` - The model is approved
     * + `REJECTED` - The model is rejected.
     * + `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
     */
    public val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * Metrics for the model.
     */
    public val modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = builder.modelMetrics
    /**
     * The Amazon Resource Name (ARN) of the model package.
     */
    public val modelPackageArn: kotlin.String? = builder.modelPackageArn
    /**
     * The description of the model package.
     */
    public val modelPackageDescription: kotlin.String? = builder.modelPackageDescription
    /**
     * The model group to which the model belongs.
     */
    public val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The name of the model.
     */
    public val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * The status of the model package. This can be one of the following values.
     * + `PENDING` - The model package is pending being created.
     * + `IN_PROGRESS` - The model package is in the process of being created.
     * + `COMPLETED` - The model package was successfully created.
     * + `FAILED` - The model package failed.
     * + `DELETING` - The model package is in the process of being deleted.
     */
    public val modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = builder.modelPackageStatus
    /**
     * Specifies the validation and image scan statuses of the model package.
     */
    public val modelPackageStatusDetails: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails? = builder.modelPackageStatusDetails
    /**
     * The version number of a versioned model.
     */
    public val modelPackageVersion: kotlin.Int? = builder.modelPackageVersion
    /**
     * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public val samplePayloadUrl: kotlin.String? = builder.samplePayloadUrl
    /**
     * Indicates if you want to skip model validation.
     */
    public val skipModelValidation: aws.sdk.kotlin.services.sagemaker.model.SkipModelValidation? = builder.skipModelValidation
    /**
     * A list of algorithms that were used to create a model package.
     */
    public val sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = builder.sourceAlgorithmSpecification
    /**
     * The URI of the source for the model package.
     */
    public val sourceUri: kotlin.String? = builder.sourceUri
    /**
     * A list of the tags associated with the model package. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
     */
    public val task: kotlin.String? = builder.task
    /**
     * Specifies batch transform jobs that SageMaker runs to validate your model package.
     */
    public val validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = builder.validationSpecification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackage(")
        append("additionalInferenceSpecifications=$additionalInferenceSpecifications,")
        append("approvalDescription=$approvalDescription,")
        append("certifyForMarketplace=$certifyForMarketplace,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("customerMetadataProperties=$customerMetadataProperties,")
        append("domain=$domain,")
        append("driftCheckBaselines=$driftCheckBaselines,")
        append("inferenceSpecification=$inferenceSpecification,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("metadataProperties=$metadataProperties,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelMetrics=$modelMetrics,")
        append("modelPackageArn=$modelPackageArn,")
        append("modelPackageDescription=$modelPackageDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageName=$modelPackageName,")
        append("modelPackageStatus=$modelPackageStatus,")
        append("modelPackageStatusDetails=$modelPackageStatusDetails,")
        append("modelPackageVersion=$modelPackageVersion,")
        append("samplePayloadUrl=$samplePayloadUrl,")
        append("skipModelValidation=$skipModelValidation,")
        append("sourceAlgorithmSpecification=$sourceAlgorithmSpecification,")
        append("sourceUri=$sourceUri,")
        append("tags=$tags,")
        append("task=$task,")
        append("validationSpecification=$validationSpecification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInferenceSpecifications?.hashCode() ?: 0
        result = 31 * result + (approvalDescription?.hashCode() ?: 0)
        result = 31 * result + (certifyForMarketplace?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (customerMetadataProperties?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (driftCheckBaselines?.hashCode() ?: 0)
        result = 31 * result + (inferenceSpecification?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelMetrics?.hashCode() ?: 0)
        result = 31 * result + (modelPackageArn?.hashCode() ?: 0)
        result = 31 * result + (modelPackageDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageStatus?.hashCode() ?: 0)
        result = 31 * result + (modelPackageStatusDetails?.hashCode() ?: 0)
        result = 31 * result + (modelPackageVersion ?: 0)
        result = 31 * result + (samplePayloadUrl?.hashCode() ?: 0)
        result = 31 * result + (skipModelValidation?.hashCode() ?: 0)
        result = 31 * result + (sourceAlgorithmSpecification?.hashCode() ?: 0)
        result = 31 * result + (sourceUri?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (validationSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackage

        if (additionalInferenceSpecifications != other.additionalInferenceSpecifications) return false
        if (approvalDescription != other.approvalDescription) return false
        if (certifyForMarketplace != other.certifyForMarketplace) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (customerMetadataProperties != other.customerMetadataProperties) return false
        if (domain != other.domain) return false
        if (driftCheckBaselines != other.driftCheckBaselines) return false
        if (inferenceSpecification != other.inferenceSpecification) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (metadataProperties != other.metadataProperties) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelMetrics != other.modelMetrics) return false
        if (modelPackageArn != other.modelPackageArn) return false
        if (modelPackageDescription != other.modelPackageDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageName != other.modelPackageName) return false
        if (modelPackageStatus != other.modelPackageStatus) return false
        if (modelPackageStatusDetails != other.modelPackageStatusDetails) return false
        if (modelPackageVersion != other.modelPackageVersion) return false
        if (samplePayloadUrl != other.samplePayloadUrl) return false
        if (skipModelValidation != other.skipModelValidation) return false
        if (sourceAlgorithmSpecification != other.sourceAlgorithmSpecification) return false
        if (sourceUri != other.sourceUri) return false
        if (tags != other.tags) return false
        if (task != other.task) return false
        if (validationSpecification != other.validationSpecification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of additional Inference Specification objects.
         */
        public var additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = null
        /**
         * A description provided when the model approval is set.
         */
        public var approvalDescription: kotlin.String? = null
        /**
         * Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information about listing model packages on Amazon Web Services Marketplace, see [List Your Algorithm or Model Package on Amazon Web Services Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html).
         */
        public var certifyForMarketplace: kotlin.Boolean? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
         */
        public var createdBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The time that the model package was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metadata properties for the model package.
         */
        public var customerMetadataProperties: Map<String, String>? = null
        /**
         * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
         */
        public var domain: kotlin.String? = null
        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package.
         */
        public var driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = null
        /**
         * Defines how to perform inference generation after a training job is run.
         */
        public var inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = null
        /**
         * Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.
         */
        public var lastModifiedBy: aws.sdk.kotlin.services.sagemaker.model.UserContext? = null
        /**
         * The last time the model package was modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        public var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * The approval status of the model. This can be one of the following values.
         * + `APPROVED` - The model is approved
         * + `REJECTED` - The model is rejected.
         * + `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
         */
        public var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * Metrics for the model.
         */
        public var modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = null
        /**
         * The Amazon Resource Name (ARN) of the model package.
         */
        public var modelPackageArn: kotlin.String? = null
        /**
         * The description of the model package.
         */
        public var modelPackageDescription: kotlin.String? = null
        /**
         * The model group to which the model belongs.
         */
        public var modelPackageGroupName: kotlin.String? = null
        /**
         * The name of the model.
         */
        public var modelPackageName: kotlin.String? = null
        /**
         * The status of the model package. This can be one of the following values.
         * + `PENDING` - The model package is pending being created.
         * + `IN_PROGRESS` - The model package is in the process of being created.
         * + `COMPLETED` - The model package was successfully created.
         * + `FAILED` - The model package failed.
         * + `DELETING` - The model package is in the process of being deleted.
         */
        public var modelPackageStatus: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatus? = null
        /**
         * Specifies the validation and image scan statuses of the model package.
         */
        public var modelPackageStatusDetails: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails? = null
        /**
         * The version number of a versioned model.
         */
        public var modelPackageVersion: kotlin.Int? = null
        /**
         * The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         */
        public var samplePayloadUrl: kotlin.String? = null
        /**
         * Indicates if you want to skip model validation.
         */
        public var skipModelValidation: aws.sdk.kotlin.services.sagemaker.model.SkipModelValidation? = null
        /**
         * A list of algorithms that were used to create a model package.
         */
        public var sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = null
        /**
         * The URI of the source for the model package.
         */
        public var sourceUri: kotlin.String? = null
        /**
         * A list of the tags associated with the model package. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.
         */
        public var task: kotlin.String? = null
        /**
         * Specifies batch transform jobs that SageMaker runs to validate your model package.
         */
        public var validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackage) : this() {
            this.additionalInferenceSpecifications = x.additionalInferenceSpecifications
            this.approvalDescription = x.approvalDescription
            this.certifyForMarketplace = x.certifyForMarketplace
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.customerMetadataProperties = x.customerMetadataProperties
            this.domain = x.domain
            this.driftCheckBaselines = x.driftCheckBaselines
            this.inferenceSpecification = x.inferenceSpecification
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.metadataProperties = x.metadataProperties
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelMetrics = x.modelMetrics
            this.modelPackageArn = x.modelPackageArn
            this.modelPackageDescription = x.modelPackageDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageName = x.modelPackageName
            this.modelPackageStatus = x.modelPackageStatus
            this.modelPackageStatusDetails = x.modelPackageStatusDetails
            this.modelPackageVersion = x.modelPackageVersion
            this.samplePayloadUrl = x.samplePayloadUrl
            this.skipModelValidation = x.skipModelValidation
            this.sourceAlgorithmSpecification = x.sourceAlgorithmSpecification
            this.sourceUri = x.sourceUri
            this.tags = x.tags
            this.task = x.task
            this.validationSpecification = x.validationSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackage = ModelPackage(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines] inside the given [block]
         */
        public fun driftCheckBaselines(block: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.Builder.() -> kotlin.Unit) {
            this.driftCheckBaselines = aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification] inside the given [block]
         */
        public fun inferenceSpecification(block: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.Builder.() -> kotlin.Unit) {
            this.inferenceSpecification = aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserContext] inside the given [block]
         */
        public fun lastModifiedBy(block: aws.sdk.kotlin.services.sagemaker.model.UserContext.Builder.() -> kotlin.Unit) {
            this.lastModifiedBy = aws.sdk.kotlin.services.sagemaker.model.UserContext.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        public fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelMetrics] inside the given [block]
         */
        public fun modelMetrics(block: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.Builder.() -> kotlin.Unit) {
            this.modelMetrics = aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails] inside the given [block]
         */
        public fun modelPackageStatusDetails(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails.Builder.() -> kotlin.Unit) {
            this.modelPackageStatusDetails = aws.sdk.kotlin.services.sagemaker.model.ModelPackageStatusDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification] inside the given [block]
         */
        public fun sourceAlgorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.sourceAlgorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification] inside the given [block]
         */
        public fun validationSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.Builder.() -> kotlin.Unit) {
            this.validationSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
