// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An entity returned by the [SearchRecord](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html) API containing the properties of a hyperparameter tuning job.
 */
public class HyperParameterTuningJobSearchEntity private constructor(builder: Builder) {
    /**
     * The container for the summary information about a training job.
     */
    public val bestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = builder.bestTrainingJob
    /**
     * The total amount of resources consumed by a hyperparameter tuning job.
     */
    public val consumedResources: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources? = builder.consumedResources
    /**
     * The time that a hyperparameter tuning job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The error that was created when a hyperparameter tuning job failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The time that a hyperparameter tuning job ended.
     */
    public val hyperParameterTuningEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.hyperParameterTuningEndTime
    /**
     * The Amazon Resource Name (ARN) of a hyperparameter tuning job.
     */
    public val hyperParameterTuningJobArn: kotlin.String? = builder.hyperParameterTuningJobArn
    /**
     * Configures a hyperparameter tuning job.
     */
    public val hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = builder.hyperParameterTuningJobConfig
    /**
     * The name of a hyperparameter tuning job.
     */
    public val hyperParameterTuningJobName: kotlin.String? = builder.hyperParameterTuningJobName
    /**
     * The status of a hyperparameter tuning job.
     */
    public val hyperParameterTuningJobStatus: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus? = builder.hyperParameterTuningJobStatus
    /**
     * The time that a hyperparameter tuning job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.
     */
    public val objectiveStatusCounters: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters? = builder.objectiveStatusCounters
    /**
     * The container for the summary information about a training job.
     */
    public val overallBestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = builder.overallBestTrainingJob
    /**
     * The tags associated with a hyperparameter tuning job. For more information see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Defines the training jobs launched by a hyperparameter tuning job.
     */
    public val trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = builder.trainingJobDefinition
    /**
     * The job definitions included in a hyperparameter tuning job.
     */
    public val trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = builder.trainingJobDefinitions
    /**
     * The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.
     */
    public val trainingJobStatusCounters: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters? = builder.trainingJobStatusCounters
    /**
     * Information about either a current or completed hyperparameter tuning job.
     */
    public val tuningJobCompletionDetails: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails? = builder.tuningJobCompletionDetails
    /**
     * Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
     *
     * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
     *
     * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
     */
    public val warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = builder.warmStartConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobSearchEntity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HyperParameterTuningJobSearchEntity(")
        append("bestTrainingJob=$bestTrainingJob,")
        append("consumedResources=$consumedResources,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("hyperParameterTuningEndTime=$hyperParameterTuningEndTime,")
        append("hyperParameterTuningJobArn=$hyperParameterTuningJobArn,")
        append("hyperParameterTuningJobConfig=$hyperParameterTuningJobConfig,")
        append("hyperParameterTuningJobName=$hyperParameterTuningJobName,")
        append("hyperParameterTuningJobStatus=$hyperParameterTuningJobStatus,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("objectiveStatusCounters=$objectiveStatusCounters,")
        append("overallBestTrainingJob=$overallBestTrainingJob,")
        append("tags=$tags,")
        append("trainingJobDefinition=$trainingJobDefinition,")
        append("trainingJobDefinitions=$trainingJobDefinitions,")
        append("trainingJobStatusCounters=$trainingJobStatusCounters,")
        append("tuningJobCompletionDetails=$tuningJobCompletionDetails,")
        append("warmStartConfig=$warmStartConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bestTrainingJob?.hashCode() ?: 0
        result = 31 * result + (consumedResources?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningEndTime?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobArn?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobConfig?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobName?.hashCode() ?: 0)
        result = 31 * result + (hyperParameterTuningJobStatus?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (objectiveStatusCounters?.hashCode() ?: 0)
        result = 31 * result + (overallBestTrainingJob?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinition?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinitions?.hashCode() ?: 0)
        result = 31 * result + (trainingJobStatusCounters?.hashCode() ?: 0)
        result = 31 * result + (tuningJobCompletionDetails?.hashCode() ?: 0)
        result = 31 * result + (warmStartConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HyperParameterTuningJobSearchEntity

        if (bestTrainingJob != other.bestTrainingJob) return false
        if (consumedResources != other.consumedResources) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (hyperParameterTuningEndTime != other.hyperParameterTuningEndTime) return false
        if (hyperParameterTuningJobArn != other.hyperParameterTuningJobArn) return false
        if (hyperParameterTuningJobConfig != other.hyperParameterTuningJobConfig) return false
        if (hyperParameterTuningJobName != other.hyperParameterTuningJobName) return false
        if (hyperParameterTuningJobStatus != other.hyperParameterTuningJobStatus) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (objectiveStatusCounters != other.objectiveStatusCounters) return false
        if (overallBestTrainingJob != other.overallBestTrainingJob) return false
        if (tags != other.tags) return false
        if (trainingJobDefinition != other.trainingJobDefinition) return false
        if (trainingJobDefinitions != other.trainingJobDefinitions) return false
        if (trainingJobStatusCounters != other.trainingJobStatusCounters) return false
        if (tuningJobCompletionDetails != other.tuningJobCompletionDetails) return false
        if (warmStartConfig != other.warmStartConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobSearchEntity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The container for the summary information about a training job.
         */
        public var bestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = null
        /**
         * The total amount of resources consumed by a hyperparameter tuning job.
         */
        public var consumedResources: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources? = null
        /**
         * The time that a hyperparameter tuning job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The error that was created when a hyperparameter tuning job failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The time that a hyperparameter tuning job ended.
         */
        public var hyperParameterTuningEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of a hyperparameter tuning job.
         */
        public var hyperParameterTuningJobArn: kotlin.String? = null
        /**
         * Configures a hyperparameter tuning job.
         */
        public var hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = null
        /**
         * The name of a hyperparameter tuning job.
         */
        public var hyperParameterTuningJobName: kotlin.String? = null
        /**
         * The status of a hyperparameter tuning job.
         */
        public var hyperParameterTuningJobStatus: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobStatus? = null
        /**
         * The time that a hyperparameter tuning job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.
         */
        public var objectiveStatusCounters: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters? = null
        /**
         * The container for the summary information about a training job.
         */
        public var overallBestTrainingJob: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary? = null
        /**
         * The tags associated with a hyperparameter tuning job. For more information see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Defines the training jobs launched by a hyperparameter tuning job.
         */
        public var trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = null
        /**
         * The job definitions included in a hyperparameter tuning job.
         */
        public var trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = null
        /**
         * The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.
         */
        public var trainingJobStatusCounters: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters? = null
        /**
         * Information about either a current or completed hyperparameter tuning job.
         */
        public var tuningJobCompletionDetails: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails? = null
        /**
         * Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
         *
         * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
         *
         * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
         */
        public var warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobSearchEntity) : this() {
            this.bestTrainingJob = x.bestTrainingJob
            this.consumedResources = x.consumedResources
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.hyperParameterTuningEndTime = x.hyperParameterTuningEndTime
            this.hyperParameterTuningJobArn = x.hyperParameterTuningJobArn
            this.hyperParameterTuningJobConfig = x.hyperParameterTuningJobConfig
            this.hyperParameterTuningJobName = x.hyperParameterTuningJobName
            this.hyperParameterTuningJobStatus = x.hyperParameterTuningJobStatus
            this.lastModifiedTime = x.lastModifiedTime
            this.objectiveStatusCounters = x.objectiveStatusCounters
            this.overallBestTrainingJob = x.overallBestTrainingJob
            this.tags = x.tags
            this.trainingJobDefinition = x.trainingJobDefinition
            this.trainingJobDefinitions = x.trainingJobDefinitions
            this.trainingJobStatusCounters = x.trainingJobStatusCounters
            this.tuningJobCompletionDetails = x.tuningJobCompletionDetails
            this.warmStartConfig = x.warmStartConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobSearchEntity = HyperParameterTuningJobSearchEntity(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary] inside the given [block]
         */
        public fun bestTrainingJob(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.Builder.() -> kotlin.Unit) {
            this.bestTrainingJob = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources] inside the given [block]
         */
        public fun consumedResources(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources.Builder.() -> kotlin.Unit) {
            this.consumedResources = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConsumedResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        public fun hyperParameterTuningJobConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters] inside the given [block]
         */
        public fun objectiveStatusCounters(block: aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters.Builder.() -> kotlin.Unit) {
            this.objectiveStatusCounters = aws.sdk.kotlin.services.sagemaker.model.ObjectiveStatusCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary] inside the given [block]
         */
        public fun overallBestTrainingJob(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.Builder.() -> kotlin.Unit) {
            this.overallBestTrainingJob = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition] inside the given [block]
         */
        public fun trainingJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder.() -> kotlin.Unit) {
            this.trainingJobDefinition = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters] inside the given [block]
         */
        public fun trainingJobStatusCounters(block: aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters.Builder.() -> kotlin.Unit) {
            this.trainingJobStatusCounters = aws.sdk.kotlin.services.sagemaker.model.TrainingJobStatusCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails] inside the given [block]
         */
        public fun tuningJobCompletionDetails(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails.Builder.() -> kotlin.Unit) {
            this.tuningJobCompletionDetails = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobCompletionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig] inside the given [block]
         */
        public fun warmStartConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.Builder.() -> kotlin.Unit) {
            this.warmStartConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
