// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeInferenceRecommendationsJobResponse private constructor(builder: Builder) {
    /**
     * A timestamp that shows when the job completed.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * A timestamp that shows when the job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The performance results from running an Inference Recommender job on an existing endpoint.
     */
    public val endpointPerformances: List<EndpointPerformance>? = builder.endpointPerformances
    /**
     * If the job fails, provides information why the job failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The recommendations made by Inference Recommender.
     */
    public val inferenceRecommendations: List<InferenceRecommendation>? = builder.inferenceRecommendations
    /**
     * Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.
     */
    public val inputConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig? = builder.inputConfig
    /**
     * The Amazon Resource Name (ARN) of the job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The job description that you provided when you initiated the job.
     */
    public val jobDescription: kotlin.String? = builder.jobDescription
    /**
     * The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The job type that you provided when you initiated the job.
     */
    public val jobType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobType? = builder.jobType
    /**
     * A timestamp that shows when the job was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The status of the job.
     */
    public val status: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStatus? = builder.status
    /**
     * The stopping conditions that you provided when you initiated the job.
     */
    public val stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions? = builder.stoppingConditions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInferenceRecommendationsJobResponse(")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("endpointPerformances=$endpointPerformances,")
        append("failureReason=$failureReason,")
        append("inferenceRecommendations=$inferenceRecommendations,")
        append("inputConfig=$inputConfig,")
        append("jobArn=$jobArn,")
        append("jobDescription=$jobDescription,")
        append("jobName=$jobName,")
        append("jobType=$jobType,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("stoppingConditions=$stoppingConditions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endpointPerformances?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (inferenceRecommendations?.hashCode() ?: 0)
        result = 31 * result + (inputConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobDescription?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stoppingConditions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInferenceRecommendationsJobResponse

        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (endpointPerformances != other.endpointPerformances) return false
        if (failureReason != other.failureReason) return false
        if (inferenceRecommendations != other.inferenceRecommendations) return false
        if (inputConfig != other.inputConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobDescription != other.jobDescription) return false
        if (jobName != other.jobName) return false
        if (jobType != other.jobType) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (stoppingConditions != other.stoppingConditions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A timestamp that shows when the job completed.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that shows when the job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The performance results from running an Inference Recommender job on an existing endpoint.
         */
        public var endpointPerformances: List<EndpointPerformance>? = null
        /**
         * If the job fails, provides information why the job failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The recommendations made by Inference Recommender.
         */
        public var inferenceRecommendations: List<InferenceRecommendation>? = null
        /**
         * Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.
         */
        public var inputConfig: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The job description that you provided when you initiated the job.
         */
        public var jobDescription: kotlin.String? = null
        /**
         * The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
         */
        public var jobName: kotlin.String? = null
        /**
         * The job type that you provided when you initiated the job.
         */
        public var jobType: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobType? = null
        /**
         * A timestamp that shows when the job was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The status of the job.
         */
        public var status: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStatus? = null
        /**
         * The stopping conditions that you provided when you initiated the job.
         */
        public var stoppingConditions: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse) : this() {
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.endpointPerformances = x.endpointPerformances
            this.failureReason = x.failureReason
            this.inferenceRecommendations = x.inferenceRecommendations
            this.inputConfig = x.inputConfig
            this.jobArn = x.jobArn
            this.jobDescription = x.jobDescription
            this.jobName = x.jobName
            this.jobType = x.jobType
            this.lastModifiedTime = x.lastModifiedTime
            this.roleArn = x.roleArn
            this.status = x.status
            this.stoppingConditions = x.stoppingConditions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse = DescribeInferenceRecommendationsJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig] inside the given [block]
         */
        public fun inputConfig(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig.Builder.() -> kotlin.Unit) {
            this.inputConfig = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobInputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions] inside the given [block]
         */
        public fun stoppingConditions(block: aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions.Builder.() -> kotlin.Unit) {
            this.stoppingConditions = aws.sdk.kotlin.services.sagemaker.model.RecommendationJobStoppingConditions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
